/*
 * Decompiled with CFR 0.152.
 */
package com.qrawless.qLib.events;

import com.qrawless.qLib.helper.StringUtils;
import com.qrawless.qLib.nbtapi.NBT;
import java.util.Objects;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.ItemStack;

public class Events
implements Listener {
    @EventHandler
    public void onInventoryClickEvent(InventoryClickEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ItemStack itemStack = event.getCurrentItem();
        if (this.isMenuItem(itemStack)) {
            event.setCancelled(true);
            if (event.getClickedInventory() != null && event.getClickedInventory().equals((Object)event.getWhoClicked().getInventory())) {
                event.setCurrentItem(null);
                event.getWhoClicked().sendMessage(StringUtils.colorize("&cA duplicated item has been deleted from your inventory."));
            }
        }
    }

    @EventHandler
    public void onInventoryClickEvent(PlayerDropItemEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ItemStack itemStack = event.getItemDrop().getItemStack();
        if (this.isMenuItem(itemStack)) {
            event.setCancelled(true);
            event.getItemDrop().remove();
            event.getPlayer().sendMessage(StringUtils.colorize("&cA duplicated item has been deleted from your inventory."));
        }
    }

    @EventHandler
    public void onItemSpawn(ItemSpawnEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ItemStack item = event.getEntity().getItemStack();
        if (this.isMenuItem(item)) {
            event.getEntity().remove();
        }
    }

    public boolean isMenuItem(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        return NBT.getComponents(item, nbt -> {
            if (nbt == null || !nbt.hasTag("minecraft:custom_data")) {
                return false;
            }
            return Objects.requireNonNull(nbt.getCompound("minecraft:custom_data")).getBoolean("q_menu_item");
        });
    }
}

