/*
 * Decompiled with CFR 0.152.
 */
package com.qrawless.qLib.modules.command;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.generator.WorldInfo;

public enum CommandArgumentType {
    PLAYER{

        @Override
        public List<String> tabComplete(String arg) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(arg.toLowerCase())).collect(Collectors.toList());
        }
    }
    ,
    NUMBER{

        @Override
        public List<String> tabComplete(String arg) {
            return Arrays.asList("1", "2", "3", "4", "5", "6", "7", "8", "9");
        }
    }
    ,
    BOOLEAN{

        @Override
        public List<String> tabComplete(String arg) {
            return Stream.of("true", "false").filter(val -> val.startsWith(arg.toLowerCase())).collect(Collectors.toList());
        }
    }
    ,
    STRING{

        @Override
        public List<String> tabComplete(String arg) {
            return Collections.emptyList();
        }
    }
    ,
    WORLD{

        @Override
        public List<String> tabComplete(String arg) {
            return Bukkit.getWorlds().stream().map(WorldInfo::getName).filter(name -> name.toLowerCase().startsWith(arg.toLowerCase())).collect(Collectors.toList());
        }
    };


    public abstract List<String> tabComplete(String var1);
}

