/*
 * Decompiled with CFR 0.152.
 */
package com.qrawless.qLib.modules.command;

import com.qrawless.qLib.helper.StringUtils;
import com.qrawless.qLib.modules.command.PluginCommandManager;
import com.qrawless.qLib.modules.command.SubCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class CommandBuilder
implements CommandExecutor,
TabCompleter {
    private final String name;
    private String description = "";
    private List<String> aliases = List.of();
    private String permission = "";
    private final List<SubCommand> subCommands = new ArrayList<SubCommand>();
    private SubCommand baseExecutor = null;
    private String usageMessage = "";
    private long cooldownMillis = 0L;
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();

    public CommandBuilder(String name) {
        this.name = name;
    }

    public CommandBuilder description(String description) {
        this.description = description;
        return this;
    }

    public CommandBuilder aliases(String ... aliases) {
        this.aliases = Arrays.asList(aliases);
        return this;
    }

    public CommandBuilder aliases(List<String> aliases) {
        this.aliases = aliases;
        return this;
    }

    public CommandBuilder permission(String permission) {
        this.permission = permission;
        return this;
    }

    public CommandBuilder execute(SubCommand executor) {
        this.baseExecutor = executor;
        return this;
    }

    public CommandBuilder addSubCommand(SubCommand subCommand) {
        this.subCommands.add(subCommand);
        return this;
    }

    public CommandBuilder usage(String usageMessage) {
        this.usageMessage = usageMessage;
        return this;
    }

    public CommandBuilder cooldown(long milliseconds) {
        this.cooldownMillis = milliseconds;
        return this;
    }

    public void register(PluginCommandManager manager) {
        manager.registerCommand(this);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public String getPermission() {
        return this.permission;
    }

    public List<SubCommand> getSubCommands() {
        return this.subCommands;
    }

    public SubCommand getBaseExecutor() {
        return this.baseExecutor;
    }

    public String getUsageMessage() {
        return this.usageMessage;
    }

    public long getCooldownMillis() {
        return this.cooldownMillis;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.permission.isEmpty() && !sender.hasPermission(this.permission)) {
            sender.sendMessage(StringUtils.colorize("&cNo permission to use this command."));
            return true;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (this.cooldownMillis > 0L) {
                long lastUse;
                long now = System.currentTimeMillis();
                if (now - (lastUse = this.cooldowns.getOrDefault(player.getUniqueId(), 0L).longValue()) < this.cooldownMillis) {
                    long secondsLeft = (this.cooldownMillis - (now - lastUse)) / 1000L;
                    player.sendMessage(StringUtils.colorize("&cYou must wait " + secondsLeft + " seconds to use this command again."));
                    return true;
                }
                this.cooldowns.put(player.getUniqueId(), now);
            }
        }
        if (args.length > 0) {
            for (SubCommand sub : this.subCommands) {
                if (!sub.getName().equalsIgnoreCase(args[0])) continue;
                return sub.executeCommand(sender, Arrays.copyOfRange(args, 1, args.length));
            }
        }
        if (this.baseExecutor != null) {
            return this.baseExecutor.executeCommand(sender, args);
        }
        if (!this.usageMessage.isEmpty()) {
            sender.sendMessage(StringUtils.colorize("&cUsage: &f" + this.usageMessage));
        }
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            for (SubCommand sub : this.subCommands) {
                boolean hasAnyPermission = sender.isOp();
                List<String> permissions = sub.getPermissions();
                if (permissions.isEmpty()) {
                    hasAnyPermission = true;
                } else {
                    for (String permission : permissions) {
                        if (!sender.hasPermission(permission)) continue;
                        hasAnyPermission = true;
                        break;
                    }
                }
                if (!sub.getName().toLowerCase().startsWith(args[0].toLowerCase()) || !hasAnyPermission) continue;
                completions.add(sub.getName());
            }
            return completions;
        }
        if (args.length > 1) {
            for (SubCommand sub : this.subCommands) {
                if (!sub.getName().equalsIgnoreCase(args[0])) continue;
                return sub.tabComplete(sender, Arrays.copyOfRange(args, 1, args.length));
            }
        }
        if (this.baseExecutor != null) {
            return this.baseExecutor.tabComplete(sender, args);
        }
        return Collections.emptyList();
    }
}

