/*
 * Decompiled with CFR 0.152.
 */
package com.qrawless.qLib.modules.command;

import com.qrawless.qLib.modules.command.CommandBuilder;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;

public class PluginCommandManager {
    private final Plugin plugin;
    private final CommandMap commandMap;
    private final Map<String, CommandBuilder> commands = new HashMap<String, CommandBuilder>();

    public PluginCommandManager(Plugin plugin) {
        this.plugin = plugin;
        this.commandMap = this.getCommandMap();
    }

    private CommandMap getCommandMap() {
        try {
            Field f = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            f.setAccessible(true);
            return (CommandMap)f.get(Bukkit.getServer());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get CommandMap!", e);
        }
    }

    public void registerCommand(CommandBuilder builder) {
        this.unregisterCommand(builder.getName());
        PluginCommand command = this.createPluginCommand(builder.getName(), this.plugin);
        command.setExecutor((CommandExecutor)builder);
        command.setTabCompleter((TabCompleter)builder);
        command.setDescription(builder.getDescription());
        command.setUsage(builder.getUsageMessage());
        command.setAliases(builder.getAliases());
        command.setPermission(builder.getPermission());
        this.commandMap.register(this.plugin.getDescription().getName(), (Command)command);
        this.commands.put(builder.getName(), builder);
    }

    private void unregisterCommand(String name) {
        try {
            this.commandMap.getKnownCommands().remove(name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private PluginCommand createPluginCommand(String name, Plugin plugin) {
        try {
            Constructor constructor = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
            constructor.setAccessible(true);
            return (PluginCommand)constructor.newInstance(name, plugin);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create PluginCommand!", e);
        }
    }

    public Map<String, CommandBuilder> getCommands() {
        return this.commands;
    }
}

