/*
 * Decompiled with CFR 0.152.
 */
package com.qrawless.qLib.modules.command;

import com.qrawless.qLib.helper.StringUtils;
import com.qrawless.qLib.modules.command.CommandArgumentType;
import com.qrawless.qLib.modules.command.CommandSenderType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class SubCommand {
    private final String name;
    private List<String> permissions = new ArrayList<String>();
    private String usage;
    private long cooldownMillis = 0L;
    private CommandSenderType senderType = CommandSenderType.BOTH;
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private final List<CommandArgumentType> argumentTypes = new ArrayList<CommandArgumentType>();
    private final List<SubCommand> subCommands = new ArrayList<SubCommand>();
    private BiConsumer<CommandSender, String[]> executor = (sender, args) -> {};

    public SubCommand(String name) {
        this.name = name;
    }

    public SubCommand permissions(List<String> permissions) {
        this.permissions = permissions;
        return this;
    }

    public SubCommand sender(CommandSenderType senderType) {
        this.senderType = senderType;
        return this;
    }

    public SubCommand usage(String usage) {
        this.usage = usage;
        return this;
    }

    public SubCommand cooldown(long millis) {
        this.cooldownMillis = millis;
        return this;
    }

    public SubCommand arguments(CommandArgumentType ... types) {
        this.argumentTypes.addAll(Arrays.asList(types));
        return this;
    }

    public SubCommand addSubCommand(SubCommand subCommand) {
        this.subCommands.add(subCommand);
        return this;
    }

    public SubCommand execute(BiConsumer<CommandSender, String[]> executor) {
        this.executor = executor;
        return this;
    }

    public boolean executeCommand(@NotNull CommandSender sender, @NotNull String[] args) {
        boolean hasAnyPermission = sender.isOp();
        if (!hasAnyPermission && !this.permissions.isEmpty()) {
            for (String permission : this.permissions) {
                if (!sender.hasPermission(permission)) continue;
                hasAnyPermission = true;
                break;
            }
            if (!hasAnyPermission) {
                sender.sendMessage(StringUtils.colorize("&cNo permission to use this command."));
                return true;
            }
        }
        if (this.senderType == CommandSenderType.PLAYER && !(sender instanceof Player)) {
            sender.sendMessage(StringUtils.colorize("&cOnly players can use this command."));
            return true;
        }
        if (this.senderType == CommandSenderType.CONSOLE && sender instanceof Player) {
            sender.sendMessage(StringUtils.colorize("&cYou can only use this command from the console."));
            return true;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (this.cooldownMillis > 0L) {
                long lastUse;
                long now = System.currentTimeMillis();
                if (now - (lastUse = this.cooldowns.getOrDefault(player.getUniqueId(), 0L).longValue()) < this.cooldownMillis) {
                    long secondsLeft = (this.cooldownMillis - (now - lastUse)) / 1000L;
                    player.sendMessage(StringUtils.colorize("&cYou must wait " + secondsLeft + " seconds to use this command again."));
                    return true;
                }
                this.cooldowns.put(player.getUniqueId(), now);
            }
        }
        if (args.length > 0) {
            for (SubCommand sub : this.subCommands) {
                if (!sub.getName().equalsIgnoreCase(args[0])) continue;
                return sub.executeCommand(sender, Arrays.copyOfRange(args, 1, args.length));
            }
        }
        this.executor.accept(sender, args);
        return true;
    }

    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String[] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            for (SubCommand sub : this.subCommands) {
                boolean hasAnyPermission = sender.isOp();
                if (sub.permissions.isEmpty()) {
                    hasAnyPermission = true;
                } else {
                    for (String permission : sub.permissions) {
                        if (!sender.hasPermission(permission)) continue;
                        hasAnyPermission = true;
                        break;
                    }
                }
                if (!sub.getName().toLowerCase().startsWith(args[0].toLowerCase()) || !hasAnyPermission) continue;
                completions.add(sub.getName());
            }
            return completions;
        }
        if (args.length > 1) {
            for (SubCommand sub : this.subCommands) {
                if (!sub.getName().equalsIgnoreCase(args[0])) continue;
                return sub.tabComplete(sender, Arrays.copyOfRange(args, 1, args.length));
            }
        }
        if (this.argumentTypes.size() >= args.length) {
            return this.argumentTypes.get(args.length - 1).tabComplete(args[args.length - 1]);
        }
        return Collections.emptyList();
    }

    public String getName() {
        return this.name;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public CommandSenderType getSenderType() {
        return this.senderType;
    }
}

