/*
 * Decompiled with CFR 0.152.
 */
package com.qrawless.qLib.modules.database;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class Database {
    private final Plugin plugin;
    private Connection connection;

    public Database(Plugin plugin) {
        this.plugin = plugin;
        this.setupConnection();
    }

    private void setupConnection() {
        FileConfiguration config = this.plugin.getConfig();
        String type = config.getString("Database.Type", "sqlite").toLowerCase();
        try {
            switch (type) {
                case "mysql": {
                    String host = config.getString("Database.Host", "localhost");
                    int port = config.getInt("Database.Port", 3306);
                    String db = config.getString("Database.Name", "database");
                    String user = config.getString("Database.User", "root");
                    String pass = config.getString("Database.Password", "");
                    String mysqlUrl = "jdbc:mysql://" + host + ":" + port + "/" + db + "?useSSL=false&autoReconnect=true";
                    this.connection = DriverManager.getConnection(mysqlUrl, user, pass);
                    break;
                }
                default: {
                    File dbFile = new File(this.plugin.getDataFolder(), "sqlite.db");
                    String sqliteUrl = "jdbc:sqlite:" + dbFile.getAbsolutePath();
                    this.connection = DriverManager.getConnection(sqliteUrl);
                    break;
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to connect to database: " + e.getMessage());
            throw new RuntimeException("Database connection failed.", e);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
            }
            catch (SQLException e) {
                this.plugin.getLogger().warning("Failed to close database connection: " + e.getMessage());
            }
        }
    }
}

