/*
 * Decompiled with CFR 0.152.
 */
package com.qrawless.qLib.modules.item;

import com.qrawless.qLib.QLib;
import com.qrawless.qLib.nbtapi.NBT;
import com.qrawless.qLib.nbtapi.iface.ReadWriteNBT;
import dev.lone.itemsadder.api.CustomStack;
import java.util.List;
import java.util.UUID;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemBuilder {
    private static ItemStack item;

    public ItemBuilder(Material material) {
        item = new ItemStack(material);
    }

    public ItemBuilder(String material) {
        CustomStack stack;
        ItemStack newItem = null;
        if (QLib.getInstance().itemsAdderHook.isEnabled() && (stack = CustomStack.getInstance((String)material)) != null) {
            newItem = stack.getItemStack();
        }
        if (newItem == null) {
            try {
                if (material.startsWith("PLAYER_HEAD:")) {
                    newItem = new ItemStack(Material.PLAYER_HEAD);
                    NBT.modifyComponents(newItem, nbt -> {
                        ReadWriteNBT profileNbt = nbt.getOrCreateCompound("minecraft:profile");
                        profileNbt.setUUID("id", UUID.randomUUID());
                        ReadWriteNBT propertiesNbt = profileNbt.getCompoundList("properties").addCompound();
                        propertiesNbt.setString("name", "textures");
                        propertiesNbt.setString("value", material.substring("PLAYER_HEAD:".length()));
                    });
                } else if (material.matches("^LEATHER_(HELMET|CHESTPLATE|LEGGINGS|BOOTS)#[0-9a-fA-F]{6}$")) {
                    String[] parts = material.split("#");
                    if (parts.length == 2) {
                        String armorType = parts[0];
                        String hexColor = parts[1];
                        Material mat = Material.matchMaterial((String)armorType);
                        if (mat != null) {
                            newItem = new ItemStack(mat);
                            LeatherArmorMeta meta = (LeatherArmorMeta)newItem.getItemMeta();
                            Color color = Color.fromRGB((int)Integer.parseInt(hexColor, 16));
                            meta.setColor(color);
                            newItem.setItemMeta((ItemMeta)meta);
                        }
                    }
                } else {
                    newItem = new ItemStack(Material.valueOf((String)material));
                }
            }
            catch (Exception e) {
                newItem = new ItemStack(Material.PAPER);
            }
        }
        item = newItem;
    }

    public ItemBuilder(ItemStack existingItem) {
        item = existingItem.clone();
    }

    public ItemBuilder setPlayerHead(OfflinePlayer player) {
        if (!item.getType().equals((Object)Material.PLAYER_HEAD)) {
            return this;
        }
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        meta.setOwner(player.getName());
        item.setItemMeta((ItemMeta)meta);
        return this;
    }

    public ItemBuilder setPlayerHead(Player player) {
        if (!item.getType().equals((Object)Material.PLAYER_HEAD)) {
            return this;
        }
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        meta.setOwner(player.getName());
        item.setItemMeta((ItemMeta)meta);
        return this;
    }

    public ItemBuilder setName(String name) {
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        item.setItemMeta(meta);
        return this;
    }

    public ItemBuilder setLore(List<String> lore) {
        ItemMeta meta = item.getItemMeta();
        meta.setLore(lore);
        item.setItemMeta(meta);
        return this;
    }

    public ItemBuilder setAmount(int amount) {
        item.setAmount(amount);
        return this;
    }

    public ItemBuilder setNBTTag(String index, String value) {
        NBT.modifyComponents(item, nbt -> nbt.getOrCreateCompound("minecraft:custom_data").setString(index, value));
        return this;
    }

    public ItemStack build() {
        return item;
    }
}

