/*
 * Decompiled with CFR 0.152.
 */
package com.qrawless.qLib.modules.log;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.plugin.java.JavaPlugin;

public class LogManager {
    private PrintWriter printWriter;

    public LogManager(JavaPlugin plugin) {
        Logger logger = Logger.getLogger("QCore");
        File file = new File(plugin.getDataFolder(), "latest.log");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try {
            this.printWriter = new PrintWriter(new FileWriter(file, true));
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Could not create log file", e);
        }
    }

    public void info(String text) {
        if (this.printWriter != null) {
            this.printWriter.println("[INFO] " + text);
            this.printWriter.flush();
        }
    }

    public void warning(String text) {
        if (this.printWriter != null) {
            this.printWriter.println("[WARNING] " + text);
            this.printWriter.flush();
        }
    }

    public void severe(String text) {
        if (this.printWriter != null) {
            this.printWriter.println("[ERROR] " + text);
            this.printWriter.flush();
        }
    }

    public void close() {
        if (this.printWriter != null) {
            this.printWriter.close();
        }
    }
}

