/*
 * Decompiled with CFR 0.152.
 */
package com.qrawless.qLib.modules.menu;

import com.qrawless.qLib.QLib;
import com.qrawless.qLib.nbtapi.NBT;
import com.qrawless.qLib.nbtapi.iface.ReadWriteNBT;
import dev.lone.itemsadder.api.CustomStack;
import java.util.List;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MenuItemBuilder {
    private static ItemStack item;

    public MenuItemBuilder(Material material) {
        item = new ItemStack(material);
        NBT.modifyComponents(item, nbt -> nbt.getOrCreateCompound("minecraft:custom_data").setBoolean("q_menu_item", true));
    }

    public MenuItemBuilder(String material) {
        CustomStack stack;
        ItemStack newItem = null;
        if (QLib.getInstance().itemsAdderHook.isEnabled() && (stack = CustomStack.getInstance((String)material)) != null) {
            newItem = stack.getItemStack();
        }
        if (newItem == null) {
            try {
                if (material.startsWith("PLAYER_HEAD:")) {
                    newItem = new ItemStack(Material.PLAYER_HEAD);
                    NBT.modifyComponents(newItem, nbt -> {
                        ReadWriteNBT profileNbt = nbt.getOrCreateCompound("minecraft:profile");
                        profileNbt.setUUID("id", UUID.randomUUID());
                        ReadWriteNBT propertiesNbt = profileNbt.getCompoundList("properties").addCompound();
                        propertiesNbt.setString("name", "textures");
                        propertiesNbt.setString("value", material.substring("PLAYER_HEAD:".length()));
                    });
                } else {
                    newItem = new ItemStack(Material.valueOf((String)material));
                }
            }
            catch (Exception e) {
                newItem = new ItemStack(Material.PAPER);
            }
        }
        NBT.modifyComponents(newItem, nbt -> nbt.getOrCreateCompound("minecraft:custom_data").setBoolean("q_menu_item", true));
        item = newItem;
    }

    public MenuItemBuilder(ItemStack existingItem) {
        item = existingItem.clone();
        NBT.modifyComponents(item, nbt -> nbt.getOrCreateCompound("minecraft:custom_data").setBoolean("q_menu_item", true));
    }

    public MenuItemBuilder setName(String name) {
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        item.setItemMeta(meta);
        return this;
    }

    public MenuItemBuilder setLore(List<String> lore) {
        ItemMeta meta = item.getItemMeta();
        meta.setLore(lore);
        item.setItemMeta(meta);
        return this;
    }

    public MenuItemBuilder setAmount(int amount) {
        item.setAmount(amount);
        return this;
    }

    public MenuItemBuilder setCustomModelData(Integer integer) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return this;
        }
        meta.setCustomModelData(integer != null && integer > 0 ? integer : null);
        item.setItemMeta(meta);
        return this;
    }

    public ItemStack build() {
        return item;
    }
}

