/*
 * Decompiled with CFR 0.152.
 */
package com.qrawless.qRewards.commands;

import com.qrawless.qLib.helper.StringUtils;
import com.qrawless.qLib.modules.command.CommandArgumentType;
import com.qrawless.qLib.modules.command.CommandBuilder;
import com.qrawless.qLib.modules.command.CommandSenderType;
import com.qrawless.qLib.modules.command.SubCommand;
import com.qrawless.qRewards.core.QPlayer;
import com.qrawless.qRewards.core.QRewards;
import com.qrawless.qRewards.menu.RewardsGui;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class Commands {
    public Commands() {
        new CommandBuilder("qrewards").description("QRewards main command").usage("/qrewards").aliases(QRewards.config.getStringList("Settings.CommandAliases")).permission("qrewards.use").execute(new SubCommand("base").sender(CommandSenderType.PLAYER).cooldown(1000L).execute((sender, args) -> QRewards.QLib.menus.openMenu(new RewardsGui(), (Player)sender))).addSubCommand(new SubCommand("leaderboard").cooldown(5000L).execute((sender, args) -> {
            sender.sendMessage(StringUtils.colorize("&6&lHighest Streak Leaderboard"));
            int rank = 1;
            for (Map.Entry<String, Integer> entry : QRewards.TOP10HighestStreak.entrySet()) {
                sender.sendMessage(StringUtils.colorize("&6" + rank + ". &7" + entry.getKey() + " &8- &d" + String.valueOf(entry.getValue()) + " &7day(s)"));
                ++rank;
            }
        })).addSubCommand(new SubCommand("reload").permissions(List.of("qrewards.admin", "qrewards.admin.command.reload")).cooldown(1000L).execute((sender, args) -> {
            QRewards.getInstance().load();
            sender.sendMessage(StringUtils.colorize(Objects.requireNonNull(QRewards.languageConfig.getString("Language.Messages.PluginReload"))));
        })).addSubCommand(new SubCommand("reset").permissions(List.of("qrewards.admin", "qrewards.admin.command.reset")).cooldown(1000L).sender(CommandSenderType.BOTH).arguments(CommandArgumentType.PLAYER).execute((sender, args) -> {
            if (((String[])args).length < 1 || args[0] == null) {
                sender.sendMessage(StringUtils.colorize(QRewards.languageConfig.getString("Language.Messages.Prefix") + "&cUsage: /qrewards reset <player>"));
                return;
            }
            OfflinePlayer player = Bukkit.getOfflinePlayer((String)args[0]);
            if (!player.hasPlayedBefore()) {
                sender.sendMessage(StringUtils.colorize(QRewards.languageConfig.getString("Language.Messages.Prefix") + "&cPlayer not found!"));
                return;
            }
            QPlayer qPlayer = QRewards.QPlayers.getOrDefault(player.getUniqueId(), null);
            if (qPlayer == null) {
                qPlayer = new QPlayer(player.getUniqueId());
            }
            qPlayer.resetRewards();
            sender.sendMessage(StringUtils.colorize(QRewards.languageConfig.getString("Language.Messages.Prefix") + "Player " + player.getName() + "'s data has been reset."));
        })).addSubCommand(new SubCommand("skip").permissions(List.of("qrewards.admin", "qrewards.admin.command.skip")).cooldown(1000L).sender(CommandSenderType.PLAYER).arguments(CommandArgumentType.STRING, CommandArgumentType.NUMBER).execute((sender, args) -> {
            if (((String[])args).length < 1) {
                sender.sendMessage(StringUtils.colorize(QRewards.languageConfig.getString("Language.Messages.Prefix") + "&cUsage: /qrewards skip <days>"));
                return;
            }
            if (sender instanceof Player) {
                Player player = (Player)sender;
                QRewards.QPlayers.get(player.getUniqueId()).setLastCollectionAt(LocalDateTime.now().minusDays(Integer.parseInt(args[0])).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                QRewards.QPlayers.get(player.getUniqueId()).update();
                sender.sendMessage(StringUtils.colorize(QRewards.languageConfig.getString("Language.Messages.Prefix") + "&6" + player.getName() + " for " + args[0] + " day skipped."));
            }
        })).addSubCommand(new SubCommand("task").permissions(List.of("qrewards.admin", "qrewards.admin.command.task")).cooldown(1000L).execute((sender, args) -> {
            QRewards.getInstance().auto();
            sender.sendMessage(StringUtils.colorize(QRewards.languageConfig.getString("Language.Messages.Prefix") + "&6Command executed. see console"));
        })).register(QRewards.QLib.commandManager);
    }
}

