/*
 * Decompiled with CFR 0.152.
 */
package com.qrawless.qRewards.core;

import com.qrawless.qRewards.core.QRewards;
import com.qrawless.qRewards.rewards.RewardsLeaderboard;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class QPlayer {
    private final UUID uuid;
    private OfflinePlayer player;
    private String playerName;
    private String lastOnline;
    private String firstCollectionAt;
    private String lastCollectionAt;
    private int highestStreak;
    private int streak;
    private int rewardId = 0;
    private final Map<Integer, String> rewards = new HashMap<Integer, String>();

    public QPlayer(UUID uuid) {
        if (QRewards.debug) {
            QRewards.logger.info("new QPlayer(UUID uuid: " + uuid.toString() + ")");
        }
        this.uuid = uuid;
        this.player = Bukkit.getOfflinePlayer((UUID)uuid);
        this.getPlayerData();
    }

    private void getPlayerData() {
        ResultSet rs;
        PreparedStatement statement2;
        if (QRewards.debug) {
            QRewards.logger.info("QPlayer.getPlayerData()");
        }
        try {
            statement2 = QRewards.QLib.getDatabase().getConnection().prepareStatement("INSERT INTO qrewards_players (uuid, player_name, last_online) VALUES (?, ?, ?)");
            try {
                statement2.setString(1, this.uuid.toString());
                statement2.setString(2, this.player.getName());
                statement2.setString(3, LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                statement2.executeUpdate();
            }
            finally {
                if (statement2 != null) {
                    statement2.close();
                }
            }
        }
        catch (SQLException statement2) {
            // empty catch block
        }
        try {
            statement2 = QRewards.QLib.getDatabase().getConnection().prepareStatement("SELECT uuid, player_name, last_online, first_collection_at, last_collection_at, highest_streak, streak FROM qrewards_players WHERE uuid = ?");
            try {
                statement2.setString(1, this.uuid.toString());
                rs = statement2.executeQuery();
                if (rs.next()) {
                    this.playerName = rs.getString("player_name");
                    this.lastOnline = rs.getString("last_online");
                    this.firstCollectionAt = rs.getString("first_collection_at");
                    this.lastCollectionAt = rs.getString("last_collection_at");
                    this.highestStreak = rs.getInt("highest_streak");
                    this.streak = rs.getInt("streak");
                }
            }
            finally {
                if (statement2 != null) {
                    statement2.close();
                }
            }
        }
        catch (SQLException e) {
            QRewards.logger.severe("Oyuncu bilgileri al\u0131n\u0131rken hata olu\u015ftu: " + e.getMessage());
        }
        try {
            statement2 = QRewards.QLib.getDatabase().getConnection().prepareStatement("SELECT reward_id FROM qrewards_player_rewards WHERE uuid = ? ORDER BY collected_at DESC LIMIT 1");
            try {
                statement2.setString(1, this.uuid.toString());
                rs = statement2.executeQuery();
                this.rewardId = rs.next() ? rs.getInt("reward_id") : 0;
                if (QRewards.debug) {
                    QRewards.logger.severe("rewardId: " + this.rewardId);
                }
            }
            finally {
                if (statement2 != null) {
                    statement2.close();
                }
            }
        }
        catch (SQLException e) {
            QRewards.logger.severe("En son toplanan \u00f6d\u00fcl ID'si al\u0131n\u0131rken hata olu\u015ftu: " + e.getMessage());
        }
        this.rewards.clear();
        try {
            statement2 = QRewards.QLib.getDatabase().getConnection().prepareStatement("SELECT reward_id, status FROM qrewards_player_rewards WHERE uuid = ?");
            try {
                statement2.setString(1, this.uuid.toString());
                try (ResultSet resultSet = statement2.executeQuery();){
                    while (resultSet.next()) {
                        int rewardId = resultSet.getInt("reward_id");
                        String status = resultSet.getString("status");
                        this.rewards.put(rewardId, status);
                    }
                    if (QRewards.debug) {
                        QRewards.logger.warning(this.getRewards().toString());
                    }
                }
            }
            finally {
                if (statement2 != null) {
                    statement2.close();
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void refresh() {
        if (QRewards.debug) {
            QRewards.logger.info("QPlayer.refresh()");
        }
        this.getPlayerData();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public String getLastOnline() {
        return this.lastOnline;
    }

    public String getFirstCollectionAt() {
        return this.firstCollectionAt;
    }

    public String getLastCollectionAt() {
        return this.lastCollectionAt;
    }

    public Integer getHighestStreak() {
        return this.highestStreak;
    }

    public Integer getStreak() {
        return this.streak;
    }

    public Integer getRewardId() {
        return this.rewardId;
    }

    public Integer getNextRewardId() {
        if (QRewards.mode.equals("DAILY")) {
            return LocalDateTime.now().getDayOfMonth();
        }
        return this.rewardId + 1;
    }

    public Map<Integer, String> getRewards() {
        return this.rewards;
    }

    public void setFirstCollectionAt(String firstCollectionAt) {
        this.firstCollectionAt = firstCollectionAt;
    }

    public void setLastCollectionAt(String lastCollectionAt) {
        this.lastCollectionAt = lastCollectionAt;
    }

    public void setLastOnline(String lastOnline) {
        this.lastOnline = lastOnline;
    }

    public void setStreak(int streak) {
        this.streak = streak;
    }

    public void updateLastOnline() {
        this.lastOnline = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public void updateLastCollectionAt() {
        this.lastCollectionAt = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public void updateFirstCollectionAt() {
        if (this.firstCollectionAt == null) {
            this.firstCollectionAt = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
    }

    public void update() {
        if (QRewards.debug) {
            QRewards.logger.info("QPlayer.update()");
        }
        try (PreparedStatement statement = QRewards.QLib.getDatabase().getConnection().prepareStatement("UPDATE qrewards_players SET player_name = ?, last_online = ?, first_collection_at = ?, last_collection_at = ?, highest_streak = ?, streak = ? WHERE uuid = ?");){
            statement.setString(1, this.player.getName());
            statement.setString(2, LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            statement.setString(3, this.firstCollectionAt != null ? this.firstCollectionAt : null);
            statement.setString(4, this.lastCollectionAt != null ? this.lastCollectionAt : null);
            statement.setInt(5, this.highestStreak);
            statement.setInt(6, this.streak);
            statement.setString(7, this.uuid.toString());
            statement.executeUpdate();
            this.refresh();
        }
        catch (SQLException e) {
            QRewards.logger.severe("Error updating player: " + e.getMessage());
        }
    }

    public void incrementStreak() {
        ++this.streak;
        if (this.streak >= this.highestStreak) {
            this.highestStreak = this.streak;
        }
        this.updateFirstCollectionAt();
        this.updateLastCollectionAt();
        this.update();
        RewardsLeaderboard.updateTop10StreakLeaderboard();
    }

    public boolean isCollectable() {
        if (this.lastCollectionAt == null || this.lastCollectionAt.isEmpty()) {
            return true;
        }
        try {
            LocalDateTime lastRewardTime = LocalDateTime.parse(this.lastCollectionAt, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            LocalDateTime now = LocalDateTime.now();
            long diff = ChronoUnit.DAYS.between(lastRewardTime.toLocalDate(), now.toLocalDate());
            return diff >= 1L;
        }
        catch (Exception e) {
            QRewards.logger.severe("[Logs] [isCollectable()] ERROR: " + String.valueOf(e));
            return false;
        }
    }

    public void resetRewards() {
        try (PreparedStatement statement = QRewards.QLib.getDatabase().getConnection().prepareStatement("DELETE FROM qrewards_player_rewards WHERE uuid = ?");){
            statement.setString(1, this.uuid.toString());
            statement.executeUpdate();
            this.setStreak(0);
            this.setLastCollectionAt(null);
            this.update();
        }
        catch (SQLException e) {
            QRewards.logger.severe("Error deleting player reward data: " + e.getMessage());
        }
    }

    public void addReward(Integer rewardId, String status) {
        if (QRewards.debug) {
            QRewards.logger.info("QPlayer.addReward(String uuid: " + String.valueOf(this.uuid) + ", Integer rewardId: " + rewardId + ", String status: " + status + ")");
        }
        try (PreparedStatement statement = QRewards.QLib.getDatabase().getConnection().prepareStatement("INSERT INTO qrewards_player_rewards (uuid, reward_id, status, collected_at) VALUES (?, ?, ?, ?)");){
            statement.setString(1, this.uuid.toString());
            statement.setInt(2, rewardId);
            statement.setString(3, status);
            statement.setString(4, LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            statement.executeUpdate();
            if (QRewards.debug) {
                QRewards.logger.info("Oyuncu \u00f6d\u00fcl\u00fc eklendi. UUID: " + String.valueOf(this.uuid) + ", \u00d6d\u00fcl ID: " + rewardId + ", Durum: " + status + ", Tarih: " + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            }
        }
        catch (SQLException e) {
            QRewards.logger.severe("Oyuncu \u00f6d\u00fcl\u00fc eklenirken hata olu\u015ftu: " + e.getMessage());
        }
    }

    public void delete() {
        PreparedStatement statement;
        if (QRewards.debug) {
            QRewards.logger.info("QPlayer.delete()");
        }
        try {
            statement = QRewards.QLib.getDatabase().getConnection().prepareStatement("DELETE FROM qrewards_player_rewards WHERE uuid = ?");
            try {
                statement.setString(1, this.uuid.toString());
                statement.executeUpdate();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException e) {
            QRewards.logger.severe("QPlayer.delete(1) Error: " + e.getMessage());
            return;
        }
        try {
            statement = QRewards.QLib.getDatabase().getConnection().prepareStatement("DELETE FROM qrewards_players WHERE uuid = ?");
            try {
                statement.setString(1, this.uuid.toString());
                statement.executeUpdate();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException e) {
            QRewards.logger.severe("QPlayer.delete(2) Error: " + e.getMessage());
            return;
        }
        QRewards.logger.warning("All data of " + this.playerName + " has been deleted. (" + String.valueOf(this.uuid) + ")");
    }
}

