/*
 * Decompiled with CFR 0.152.
 */
package com.qrawless.qRewards.core;

import com.google.common.collect.Lists;
import com.qrawless.qLib.QLib;
import com.qrawless.qLib.helper.StringUtils;
import com.qrawless.qLib.hooks.PlaceholdersAPIHook;
import com.qrawless.qRewards.commands.Commands;
import com.qrawless.qRewards.core.QPlayer;
import com.qrawless.qRewards.events.Events;
import com.qrawless.qRewards.rewards.RewardsLeaderboard;
import com.tchristofferson.configupdater.ConfigUpdater;
import de.tr7zw.changeme.nbtapi.utils.Metrics;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class QRewards
extends JavaPlugin {
    private static QRewards instance;
    public static boolean debug;
    public static boolean updateAvailable;
    public static FileConfiguration config;
    public static FileConfiguration languageConfig;
    public static FileConfiguration rewardsConfig;
    public static List<String> rewards;
    public static Logger logger;
    public static String language;
    public static String locale;
    private final List<String> languages = Lists.newArrayList((Object[])new String[]{"en_US", "tr_TR", "de_DE"});
    public static String mode;
    public static QLib QLib;
    public static final Map<String, Integer> TOP10HighestStreak;
    public static final Map<UUID, QPlayer> QPlayers;

    public void onEnable() {
        instance = this;
        logger = this.getLogger();
        QLib = new QLib((Plugin)instance);
        new Metrics(instance, 25224);
        logger.info("QRewards enabled.");
        this.load();
        this.getServer().getPluginManager().registerEvents((Listener)new Events(), (Plugin)this);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!QPlayers.get(player.getUniqueId()).isCollectable()) continue;
                player.sendMessage(StringUtils.colorize(config.getString("Prefix") + config.getString("Messages.RewardReminder")));
            }
        }, 0L, 72000L);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, this::auto, 0L, 72000L);
        if (QRewards.QLib.placeholderAPIHook.isEnabled()) {
            new PlaceholdersAPIHook((Plugin)QRewards.getInstance(), "qrewards", (player, id) -> {
                String lastRewardCollect;
                LocalDateTime now = LocalDateTime.now();
                LocalDateTime midnight = now.toLocalDate().atTime(LocalTime.MIDNIGHT).plusDays(1L);
                if (id.equalsIgnoreCase("player_last_collection_date") && (lastRewardCollect = QPlayers.get(player.getUniqueId()).getLastCollectionAt()) != null) {
                    try {
                        String[] localePart = locale.split("_");
                        SimpleDateFormat inputFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        SimpleDateFormat outputFormat = new SimpleDateFormat(Objects.requireNonNull(config.getString("Gui.Items.Profile.DateFormat")), new Locale(localePart[0], localePart[1]));
                        Date date = inputFormat.parse(lastRewardCollect);
                        return outputFormat.format(date);
                    }
                    catch (Exception e) {
                        return lastRewardCollect;
                    }
                }
                if (id.equalsIgnoreCase("player_first_collection_date")) {
                    String firstRewardCollectionDate = QPlayers.get(player.getUniqueId()).getFirstCollectionAt();
                    if (firstRewardCollectionDate != null) {
                        try {
                            String[] localePart = locale.split("_");
                            SimpleDateFormat inputFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            SimpleDateFormat outputFormat = new SimpleDateFormat(Objects.requireNonNull(config.getString("Gui.Items.Profile.DateFormat")), new Locale(localePart[0], localePart[1]));
                            Date date = inputFormat.parse(firstRewardCollectionDate);
                            return outputFormat.format(date);
                        }
                        catch (Exception e) {
                            return firstRewardCollectionDate;
                        }
                    }
                    return "";
                }
                if (id.equalsIgnoreCase("player_total_streak")) {
                    return QPlayers.get(player.getUniqueId()).getStreak().toString();
                }
                if (id.equalsIgnoreCase("player_highest_streak")) {
                    return QPlayers.get(player.getUniqueId()).getHighestStreak().toString();
                }
                if (id.equalsIgnoreCase("player_can_claim_reward")) {
                    if (QPlayers.get(player.getUniqueId()).isCollectable()) {
                        return "true";
                    }
                    return "false";
                }
                if (id.equalsIgnoreCase("player_time_until_next_reward_hours")) {
                    if (!QPlayers.get(player.getUniqueId()).isCollectable()) {
                        return String.valueOf(Duration.between(now, midnight).toHours());
                    }
                    return "true";
                }
                if (id.equalsIgnoreCase("player_time_until_next_reward_minutes_total")) {
                    if (!QPlayers.get(player.getUniqueId()).isCollectable()) {
                        return String.valueOf(Duration.between(now, midnight).toMinutes());
                    }
                    return "true";
                }
                if (id.equalsIgnoreCase("player_time_until_next_reward_minutes")) {
                    if (!QPlayers.get(player.getUniqueId()).isCollectable()) {
                        return String.valueOf(Duration.between(now, midnight).toMinutesPart());
                    }
                    return "true";
                }
                if (id.equalsIgnoreCase("player_time_until_next_reward_seconds_total")) {
                    if (!QPlayers.get(player.getUniqueId()).isCollectable()) {
                        return String.valueOf(Duration.between(now, midnight).toSeconds());
                    }
                    return "true";
                }
                if (id.equalsIgnoreCase("player_time_until_next_reward_seconds")) {
                    if (!QPlayers.get(player.getUniqueId()).isCollectable()) {
                        return String.valueOf(Duration.between(now, midnight).toSecondsPart());
                    }
                    return "true";
                }
                if (id.equalsIgnoreCase("player_time_until_next_reward")) {
                    if (!QPlayers.get(player.getUniqueId()).isCollectable()) {
                        Duration duration = Duration.between(now, midnight);
                        Object formattedTimeString = languageConfig.getString("Language.Messages.Hours") + " " + languageConfig.getString("Language.Messages.Minutes") + " " + languageConfig.getString("Language.Messages.Seconds");
                        formattedTimeString = ((String)formattedTimeString).replace("[hour]", String.valueOf(duration.toHours()));
                        formattedTimeString = ((String)formattedTimeString).replace("[minute]", String.valueOf(duration.toMinutesPart()));
                        formattedTimeString = ((String)formattedTimeString).replace("[second]", String.valueOf(duration.toSecondsPart()));
                        return formattedTimeString;
                    }
                    return "true";
                }
                for (int rank = 1; rank <= 10; ++rank) {
                    if (id.equalsIgnoreCase("highest_player_" + rank)) {
                        Map.Entry<String, Integer> entry = RewardsLeaderboard.getTopPlayerAtRank(rank);
                        if (entry != null) {
                            return String.valueOf(entry.getKey());
                        }
                        return "N/A";
                    }
                    if (!id.equalsIgnoreCase("highest_day_" + rank)) continue;
                    Map.Entry<String, Integer> entry = RewardsLeaderboard.getTopPlayerAtRank(rank);
                    if (entry != null) {
                        return String.valueOf(entry.getValue());
                    }
                    return "N/A";
                }
                return null;
            });
        }
    }

    public void onDisable() {
        logger.info("QRewards disabled.");
    }

    public void load() {
        try {
            this.saveDefaultConfig();
            ConfigUpdater.update((Plugin)this, "config.yml", new File(this.getDataFolder(), "config.yml"), new ArrayList<String>());
            this.reloadConfig();
            config = this.getConfig();
            File rewardsFile = new File(this.getDataFolder(), "rewards.yml");
            if (!rewardsFile.exists()) {
                this.saveResource("rewards.yml", false);
            }
            ConfigUpdater.update((Plugin)this, "rewards.yml", rewardsFile, List.of("Rewards"));
            rewardsConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "rewards.yml"));
            String defaultLang = this.languages.getFirst();
            File dataFolder = new File(this.getDataFolder(), "languages");
            if (!dataFolder.exists()) {
                dataFolder.mkdirs();
            }
            for (String language : this.languages) {
                File languageFile = new File(dataFolder, "messages-" + language + ".yml");
                if (!languageFile.exists()) {
                    this.saveResource("languages/messages-" + language + ".yml", false);
                }
                ConfigUpdater.update((Plugin)this, "languages/messages-" + defaultLang + ".yml", languageFile, new String[0]);
            }
            language = config.getString("Settings.Language");
            if (!this.languages.contains(language)) {
                language = "en_US";
            }
            languageConfig = YamlConfiguration.loadConfiguration((File)new File(dataFolder, "messages-" + language + ".yml"));
        }
        catch (IOException e) {
            logger.severe(e.getMessage());
        }
        try {
            QLib.getDatabase().getConnection().createStatement().executeUpdate("CREATE TABLE IF NOT EXISTS qrewards_players (uuid TEXT PRIMARY KEY UNIQUE,player_name TEXT NOT NULL,last_online DATETIME NULLABLE,first_collection_at DATETIME NULLABLE,last_collection_at DATETIME NULLABLE,highest_streak INTEGER NULLABLE DEFAULT 0,streak INTEGER NULLABLE DEFAULT 0);");
            QLib.getDatabase().getConnection().createStatement().executeUpdate("CREATE TABLE IF NOT EXISTS qrewards_player_rewards (uuid TEXT NOT NULL,reward_id INTEGER NOT NULL,status TEXT NOT NULL,collected_at DATETIME NOT NULL,FOREIGN KEY (uuid) REFERENCES qrewards_players(uuid));");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        new Commands();
        locale = Objects.requireNonNull(config.getString("Settings.Locale"));
        mode = Objects.requireNonNull(config.getString("Settings.Modes.Mode"));
        rewards = new ArrayList<String>(Objects.requireNonNull(rewardsConfig.getConfigurationSection("Rewards")).getKeys(false));
        logger.info("QRewards successfully loaded!");
        this.checkForUpdate();
        RewardsLeaderboard.updateTop10StreakLeaderboard();
    }

    public void auto() {
        QPlayer qPlayer;
        UUID uuid;
        ResultSet rs;
        int InactiveDay = 30;
        if (debug) {
            logger.info("");
        }
        if (debug) {
            logger.info("A U T O   P U R G E");
        }
        try (PreparedStatement preparedStatement = QLib.getDatabase().getConnection().prepareStatement("SELECT uuid FROM qrewards_players WHERE last_online < date('now', '-" + InactiveDay + " days')");){
            rs = preparedStatement.executeQuery();
            try {
                while (rs.next()) {
                    try {
                        uuid = UUID.fromString(rs.getString("uuid"));
                        qPlayer = QPlayers.getOrDefault(uuid, null);
                        if (qPlayer == null) {
                            qPlayer = new QPlayer(uuid);
                        }
                        qPlayer.delete();
                        QPlayers.remove(uuid);
                    }
                    catch (IllegalArgumentException e) {
                        System.err.println("Ge\u00e7ersiz UUID format\u0131: " + rs.getString("uuid"));
                    }
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (SQLException e) {
            logger.info("Error fetching inactive user UUIDs: " + e.getMessage());
        }
        if (mode.equals("STREAK") && config.getBoolean("Settings.Modes.Streak.EnableMissedDays")) {
            if (debug) {
                logger.info("");
            }
            if (debug) {
                logger.info("A U T O   M I S S E D   D A Y S");
            }
            try (PreparedStatement stmt = QLib.getDatabase().getConnection().prepareStatement("SELECT * FROM qrewards_players WHERE last_collection_at < datetime('now', '-1 days')");){
                rs = stmt.executeQuery();
                try {
                    while (rs.next()) {
                        uuid = UUID.fromString(rs.getString("uuid"));
                        qPlayer = QPlayers.getOrDefault(uuid, null);
                        if (qPlayer == null) {
                            qPlayer = new QPlayer(uuid);
                        }
                        qPlayer.updateLastCollectionAt();
                        qPlayer.incrementStreak();
                        qPlayer.addReward(qPlayer.getNextRewardId(), "MISSED");
                        qPlayer.update();
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (mode.equals("STREAK") && config.getBoolean("Settings.Modes.Streak.EnableMissedDays") && config.getInt("Settings.Modes.Streak.MaxMissedDays") > 0) {
            if (debug) {
                logger.info("");
            }
            if (debug) {
                logger.info("M A X   M I S S E D   D A Y S");
            }
            HashMap<String, Integer> maxMissedDays = new HashMap<String, Integer>();
            int maxMissedDay = config.getInt("Settings.Modes.Streak.MaxMissedDays");
            try (PreparedStatement stmt = QLib.getDatabase().getConnection().prepareStatement("SELECT uuid, status, collected_at FROM qrewards_player_rewards ORDER BY uuid, datetime(collected_at) ASC");
                 ResultSet rs2 = stmt.executeQuery();){
                while (rs2.next()) {
                    String uuid2 = rs2.getString("uuid");
                    String status = rs2.getString("status");
                    if (status.equals("MISSED")) {
                        if (!maxMissedDays.containsKey(uuid2)) {
                            maxMissedDays.put(uuid2, 1);
                            continue;
                        }
                        maxMissedDays.put(uuid2, (Integer)maxMissedDays.get(uuid2) + 1);
                        continue;
                    }
                    maxMissedDays.put(uuid2, 0);
                }
                for (Map.Entry entry : maxMissedDays.entrySet()) {
                    UUID uuid3 = UUID.fromString((String)entry.getKey());
                    OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid3);
                    int missedCount = (Integer)entry.getValue();
                    if (missedCount < maxMissedDay) continue;
                    logger.info("[Logs] Player " + player.getName() + "'s series ended as maximum missed days exceeded (" + missedCount + "/" + maxMissedDay + ")");
                    QPlayer qPlayer2 = QPlayers.getOrDefault(uuid3, null);
                    if (qPlayer2 == null) {
                        qPlayer2 = new QPlayer(uuid3);
                    }
                    qPlayer2.setLastCollectionAt(LocalDateTime.now().minusDays(1L).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                    qPlayer2.resetRewards();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static QRewards getInstance() {
        return instance;
    }

    public void checkForUpdate() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            try {
                URL url = new URL("https://api.spigotmc.org/legacy/update.php?resource=123283");
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String latestVersion = reader.readLine().trim();
                reader.close();
                String currentVersion = this.getDescription().getVersion().trim();
                String[] latestParts = latestVersion.split("\\.");
                String[] currentParts = currentVersion.split("\\.");
                int maxLength = Math.max(latestParts.length, currentParts.length);
                boolean isNewer = false;
                for (int i = 0; i < maxLength; ++i) {
                    int currentNum;
                    int latestNum = i < latestParts.length ? Integer.parseInt(latestParts[i].replaceAll("[^0-9]", "")) : 0;
                    int n = currentNum = i < currentParts.length ? Integer.parseInt(currentParts[i].replaceAll("[^0-9]", "")) : 0;
                    if (latestNum > currentNum) {
                        isNewer = true;
                        break;
                    }
                    if (latestNum < currentNum) break;
                }
                if (isNewer) {
                    Bukkit.getScheduler().runTask((Plugin)this, () -> {
                        Bukkit.getConsoleSender().sendMessage(StringUtils.colorize("#ffffff[" + this.getName() + "] #13a10eA new update is available! (" + latestVersion + "), current version: " + currentVersion));
                        updateAvailable = true;
                    });
                }
            }
            catch (Exception e) {
                logger.warning("Update check failed: " + e.getMessage());
            }
        });
    }

    static {
        debug = false;
        updateAvailable = false;
        language = "en_US";
        locale = "en_US";
        TOP10HighestStreak = new HashMap<String, Integer>();
        QPlayers = new HashMap<UUID, QPlayer>();
    }
}

