/*
 * Decompiled with CFR 0.152.
 */
package com.qrawless.qRewards.menu;

import com.qrawless.qLib.helper.StringUtils;
import com.qrawless.qLib.modules.menu.MenuItemBuilder;
import com.qrawless.qRewards.core.QRewards;
import com.qrawless.qRewards.menu.GuiItem;
import com.qrawless.qRewards.rewards.Reward;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.odalitadevelopments.menus.OdalitaMenus;
import nl.odalitadevelopments.menus.annotations.Menu;
import nl.odalitadevelopments.menus.contents.MenuContents;
import nl.odalitadevelopments.menus.items.MenuItem;
import nl.odalitadevelopments.menus.items.UpdatableItem;
import nl.odalitadevelopments.menus.iterators.MenuIterator;
import nl.odalitadevelopments.menus.iterators.MenuIteratorType;
import nl.odalitadevelopments.menus.menu.providers.PlayerMenuProvider;
import nl.odalitadevelopments.menus.menu.type.MenuType;
import nl.odalitadevelopments.menus.pagination.Pagination;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;

@Menu(title="Loading...", type=MenuType.CHEST_6_ROW)
public class RewardsGui
implements PlayerMenuProvider {
    Player player;
    Pagination pagination;

    @Override
    public void onLoad(final @NotNull Player player, @NotNull MenuContents contents) {
        this.player = player;
        int rewardId = QRewards.QPlayers.get(player.getUniqueId()).getRewardId();
        int nextRewardId = QRewards.QPlayers.get(player.getUniqueId()).getNextRewardId();
        contents.setTitle(StringUtils.colorize(Objects.requireNonNull(QRewards.languageConfig.getString("Language.Gui.Title"))));
        contents.setMenuType(MenuType.valueOf("CHEST_" + QRewards.config.getInt("Gui.Rows") + "_ROW"));
        contents.fill(new GuiItem().BackgroundItem(inventoryClickEvent -> {}));
        int totalSlots = QRewards.config.getInt("Gui.Rows") * 9;
        List whitelist = Objects.requireNonNull(QRewards.config.getIntegerList("Gui.PageSlots"));
        ArrayList<Integer> filteredList = new ArrayList<Integer>();
        for (int i = 0; i < totalSlots; ++i) {
            if (whitelist.contains(i)) continue;
            filteredList.add(i);
        }
        for (Integer slot : whitelist) {
            contents.set(slot, new MenuItem(this){

                @Override
                @NotNull
                protected ItemStack getItemStack(@NotNull OdalitaMenus odalitaMenus, @NotNull MenuContents menuContents) {
                    return new ItemStack(Material.AIR);
                }

                @Override
                @NotNull
                public Consumer<InventoryClickEvent> onClick(@NotNull OdalitaMenus odalitaMenus, @NotNull MenuContents menuContents) {
                    return null;
                }
            });
        }
        this.pagination = contents.pagination("qrewards_pagination", whitelist.size()).asyncPageSwitching(false).iterator((MenuIterator)contents.createIterator("qrewards_pagination_iterator", MenuIteratorType.HORIZONTAL, 0, 0).blacklist(filteredList.stream().mapToInt(Integer::intValue).toArray())).create();
        for (String index : QRewards.rewards) {
            int updateTick = nextRewardId == Integer.parseInt(index) ? 20 : 100;
            Supplier<ItemStack> itemStackSupplier = () -> new Reward(index, player).getRewardItem();
            Consumer<InventoryClickEvent> clickHandler = event -> this.rewardCollect(index);
            this.pagination.addItem(() -> UpdatableItem.of(itemStackSupplier, clickHandler, updateTick));
        }
        this.pagination.setPage(rewardId / Objects.requireNonNull(QRewards.config.getIntegerList("Gui.PageSlots")).size());
        contents.set(QRewards.config.getInt("Gui.Items.Previous.Slot"), new GuiItem().PreviousItem(inventoryClickEvent -> this.pagination.previousPage()));
        contents.set(QRewards.config.getInt("Gui.Items.Next.Slot"), new GuiItem().NextItem(inventoryClickEvent -> this.pagination.nextPage()));
        contents.set(QRewards.config.getInt("Gui.Items.Exit.Slot"), new GuiItem().ExitItem(inventoryClickEvent -> {}));
        contents.set(4, new MenuItem(this){

            @Override
            @NotNull
            protected ItemStack getItemStack(@NotNull OdalitaMenus odalitaMenus, @NotNull MenuContents menuContents) {
                MenuItemBuilder menuItemBuilder;
                ArrayList<String> legacyLore = new ArrayList<String>();
                ArrayList lore = new ArrayList(Objects.requireNonNull(QRewards.languageConfig.getStringList("Language.Gui.Items.Profile.Lore")));
                for (String line : lore) {
                    int placeholderEnd;
                    if (line.contains("[first_reward_collection_date|")) {
                        placeholderEnd = line.indexOf("]", line.indexOf("[first_reward_collection_date|"));
                        if (placeholderEnd != -1) {
                            placeholderFull = line.substring(line.indexOf("[first_reward_collection_date|"), placeholderEnd + 1);
                            defaultMessage = placeholderFull.substring("[first_reward_collection_date|".length(), placeholderFull.length() - 1);
                            if (QRewards.QPlayers.get(player.getUniqueId()).getFirstCollectionAt() != null && !QRewards.QPlayers.get(player.getUniqueId()).getFirstCollectionAt().isEmpty()) {
                                try {
                                    String[] localePart = QRewards.locale.split("_");
                                    SimpleDateFormat inputFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                    SimpleDateFormat outputFormat = new SimpleDateFormat(Objects.requireNonNull(QRewards.config.getString("Gui.Items.Profile.DateFormat")), new Locale(localePart[0], localePart[1]));
                                    Date date = inputFormat.parse(QRewards.QPlayers.get(player.getUniqueId()).getFirstCollectionAt());
                                    line = line.replace(placeholderFull, outputFormat.format(date));
                                }
                                catch (Exception e) {
                                    line = line.replace(placeholderFull, QRewards.QPlayers.get(player.getUniqueId()).getFirstCollectionAt());
                                }
                            } else {
                                line = line.replace(placeholderFull, defaultMessage);
                            }
                        }
                    } else if (line.contains("[total_streak|")) {
                        placeholderEnd = line.indexOf("]", line.indexOf("[total_streak|"));
                        if (placeholderEnd != -1) {
                            placeholderFull = line.substring(line.indexOf("[total_streak|"), placeholderEnd + 1);
                            defaultMessage = placeholderFull.substring("[total_streak|".length(), placeholderFull.length() - 1);
                            line = QRewards.QPlayers.get(player.getUniqueId()).getStreak() != null ? line.replace(placeholderFull, QRewards.QPlayers.get(player.getUniqueId()).getStreak().toString()) : line.replace(placeholderFull, defaultMessage);
                        }
                    } else if (line.contains("[highest_streak|") && (placeholderEnd = line.indexOf("]", line.indexOf("[highest_streak|"))) != -1) {
                        placeholderFull = line.substring(line.indexOf("[highest_streak|"), placeholderEnd + 1);
                        defaultMessage = placeholderFull.substring("[highest_streak|".length(), placeholderFull.length() - 1);
                        line = QRewards.QPlayers.get(player.getUniqueId()).getHighestStreak() != null ? line.replace(placeholderFull, QRewards.QPlayers.get(player.getUniqueId()).getHighestStreak().toString()) : line.replace(placeholderFull, defaultMessage);
                    }
                    legacyLore.add(line);
                }
                String material = Objects.requireNonNull(QRewards.config.getString("Gui.Items.Profile.Material"));
                if (material.equals("PLAYER_HEAD:PLAYER")) {
                    ItemStack itemStack = new ItemStack(Material.PLAYER_HEAD);
                    SkullMeta meta = (SkullMeta)itemStack.getItemMeta();
                    meta.setOwner(player.getName());
                    itemStack.setItemMeta((ItemMeta)meta);
                    menuItemBuilder = new MenuItemBuilder(itemStack);
                } else {
                    menuItemBuilder = new MenuItemBuilder(material);
                }
                menuItemBuilder.setCustomModelData(QRewards.config.getInt("Gui.Items.Profile.CustomModelData"));
                String name = Objects.requireNonNull(QRewards.languageConfig.getString("Language.Gui.Items.Profile.Name"));
                name = name.replace("[player]", player.getName());
                return menuItemBuilder.setName(StringUtils.colorize(name)).setLore(StringUtils.loreColorize(legacyLore)).build();
            }

            @Override
            @NotNull
            public Consumer<InventoryClickEvent> onClick(@NotNull OdalitaMenus odalitaMenus, @NotNull MenuContents menuContents) {
                return inventoryClickEvent -> inventoryClickEvent.setCancelled(true);
            }
        });
    }

    private void rewardCollect(String index) {
        int nextRewardId = QRewards.QPlayers.get(this.player.getUniqueId()).getNextRewardId();
        boolean isCollectable = QRewards.QPlayers.get(this.player.getUniqueId()).isCollectable();
        if (nextRewardId == Integer.parseInt(index) && isCollectable) {
            String subTitle;
            String title;
            this.player.closeInventory();
            QRewards.QPlayers.get(this.player.getUniqueId()).updateLastCollectionAt();
            QRewards.QPlayers.get(this.player.getUniqueId()).updateLastOnline();
            QRewards.QPlayers.get(this.player.getUniqueId()).update();
            if (QRewards.config.getBoolean("Settings.Logs")) {
                QRewards.logger.info("[Logs] " + this.player.getName() + " collected day " + index + " reward.");
            }
            Object rewardCollectText = QRewards.languageConfig.getString("Language.Messages.Prefix") + QRewards.languageConfig.getString("Language.Messages.RewardCollected");
            rewardCollectText = ((String)rewardCollectText).replace("[day]", index);
            this.player.sendMessage(StringUtils.colorize((String)rewardCollectText));
            Object reminderTomorrowText = QRewards.languageConfig.getString("Language.Messages.Prefix") + QRewards.languageConfig.getString("Language.Messages.ReminderTomorrow");
            reminderTomorrowText = ((String)reminderTomorrowText).replace("[day]", index);
            this.player.sendMessage(StringUtils.colorize((String)reminderTomorrowText));
            if (nextRewardId == QRewards.rewards.size()) {
                QRewards.QPlayers.get(this.player.getUniqueId()).resetRewards();
                this.player.sendMessage(StringUtils.colorize(QRewards.languageConfig.getString("Language.Messages.Prefix") + QRewards.languageConfig.getString("Language.Messages.RewardsReset")));
                if (QRewards.config.getBoolean("Settings.Logs")) {
                    QRewards.logger.info("[Logs] " + this.player.getName() + " has reached the end of the rewards and the reward data has been reset to zero.");
                }
            } else {
                QRewards.QPlayers.get(this.player.getUniqueId()).incrementStreak();
                QRewards.QPlayers.get(this.player.getUniqueId()).addReward(Integer.parseInt(index), "COLLECTED");
                QRewards.QPlayers.get(this.player.getUniqueId()).update();
            }
            for (String command : new ArrayList(Objects.requireNonNull(QRewards.rewardsConfig.getStringList("Rewards." + index + ".RewardCommands")))) {
                command = command.replace("[player]", this.player.getName());
                command = command.replace("[UUID]", this.player.getUniqueId().toString());
                command = command.replace("[day]", index);
                Matcher PermissionExpression = Pattern.compile("\\[permission=(.*?)\\](.*)").matcher(command);
                if (PermissionExpression.find()) {
                    String permission = PermissionExpression.group(1);
                    command = PermissionExpression.group(2).trim();
                    if (permission.isEmpty() || !this.player.hasPermission(permission)) continue;
                }
                if (QRewards.config.getBoolean("Settings.Logs")) {
                    QRewards.logger.info("[Logs] " + this.player.getName() + ", reward command executed [" + command + "]");
                }
                Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), command);
            }
            if (QRewards.mode.equals("STREAK")) {
                title = Objects.requireNonNull(QRewards.languageConfig.getString("Language.Mode.Streak.Titles.Collect.Title"));
                subTitle = Objects.requireNonNull(QRewards.languageConfig.getString("Language.Mode.Streak.Titles.Collect.SubTitle"));
                title = title.replace("[day]", index);
                subTitle = subTitle.replace("[day]", index);
                this.player.sendTitle(StringUtils.colorize(title), StringUtils.colorize(subTitle), QRewards.config.getInt("Settings.Modes.Streak.Titles.Collect.FadeIn", 20) * 20, QRewards.config.getInt("Settings.Modes.Streak.Titles.Collect.Duration", 100) * 20, QRewards.config.getInt("Settings.Modes.Streak.Titles.Collect.FadeOut", 20) * 20);
            }
            if (QRewards.mode.equals("DAILY")) {
                title = Objects.requireNonNull(QRewards.languageConfig.getString("Language.Mode.Daily.Titles.Collect.Title"));
                subTitle = Objects.requireNonNull(QRewards.languageConfig.getString("Language.Mode.Daily.Titles.Collect.SubTitle"));
                title = title.replace("[day]", index);
                subTitle = subTitle.replace("[day]", index);
                this.player.sendTitle(StringUtils.colorize(title), StringUtils.colorize(subTitle), QRewards.config.getInt("Settings.Modes.Daily.Titles.Collect.FadeIn", 20) * 20, QRewards.config.getInt("Settings.Modes.Daily.Titles.Collect.Duration", 100) * 20, QRewards.config.getInt("Settings.Modes.Daily.Titles.Collect.FadeOut", 20) * 20);
            }
        }
    }
}

