/*
 * Decompiled with CFR 0.152.
 */
package com.qrawless.qRewards.rewards;

import com.qrawless.qLib.helper.StringUtils;
import com.qrawless.qLib.modules.menu.MenuItemBuilder;
import com.qrawless.qRewards.core.QRewards;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class Reward {
    private final Player player;
    private final String index;
    private final String rewardStatus;

    public Reward(String index, Player player) {
        this.player = player;
        this.index = index;
        this.rewardStatus = this.getRewardStatus(index);
    }

    public ItemStack getRewardItem() {
        return new MenuItemBuilder(this.getRewardMaterial(this.index)).setName(this.getRewardName(this.index)).setLore(this.getRewardLore(this.index)).build();
    }

    @NotNull
    private String getRewardStatus(String index) {
        String rewardStatus = QRewards.QPlayers.get(this.player.getUniqueId()).getRewards().get(Integer.parseInt(index));
        int rewardId = QRewards.QPlayers.get(this.player.getUniqueId()).getRewardId();
        int nextRewardId = QRewards.QPlayers.get(this.player.getUniqueId()).getNextRewardId();
        boolean isCollectable = QRewards.QPlayers.get(this.player.getUniqueId()).isCollectable();
        if (rewardStatus != null && rewardStatus.equals("COLLECTED")) {
            return "CLAIMED_REWARD";
        }
        if (rewardStatus != null && rewardStatus.equals("MISSED")) {
            return "MISSED_REWARD";
        }
        if (nextRewardId == Integer.parseInt(index) && isCollectable) {
            return "REWARD_READY";
        }
        if (nextRewardId == Integer.parseInt(index) && QRewards.mode.equals("STREAK")) {
            return "FUTURE_REWARD";
        }
        if (QRewards.mode.equals("DAILY") && Integer.toString(rewardId + 1).equals(index)) {
            return "FUTURE_REWARD";
        }
        if (Integer.parseInt(index) > rewardId) {
            return "REWARD_NOT_READY";
        }
        return "MISSED_REWARD";
    }

    @NotNull
    private String getRewardName(String index) {
        String name;
        switch (this.rewardStatus) {
            case "CLAIMED_REWARD": {
                String string = QRewards.languageConfig.getString("Language.Gui.Items.ClaimedReward.Name");
                break;
            }
            case "REWARD_READY": {
                String string = QRewards.languageConfig.getString("Language.Gui.Items.RewardReady.Name");
                break;
            }
            case "REWARD_NOT_READY": {
                String string = QRewards.languageConfig.getString("Language.Gui.Items.RewardNotReady.Name");
                break;
            }
            case "FUTURE_REWARD": {
                String string = QRewards.languageConfig.getString("Language.Gui.Items.FutureReward.Name");
                break;
            }
            default: {
                String string = name = QRewards.languageConfig.getString("Language.Gui.Items.MissedReward.Name");
            }
        }
        if (name == null) {
            name = "error";
        }
        name = name.replace("[day]", index);
        return StringUtils.colorize(name);
    }

    private String getRewardMaterial(String index) {
        String material = switch (this.rewardStatus) {
            case "CLAIMED_REWARD" -> QRewards.rewardsConfig.getString("Rewards." + index + ".Materials.CollectedRewardIcon");
            case "REWARD_READY" -> QRewards.rewardsConfig.getString("Rewards." + index + ".Materials.CollectableRewardIcon");
            case "REWARD_NOT_READY", "FUTURE_REWARD" -> QRewards.rewardsConfig.getString("Rewards." + index + ".Materials.RewardIcon");
            default -> QRewards.rewardsConfig.getString("Rewards." + index + ".Materials.MissedRewardIcon");
        };
        return material;
    }

    private List<String> getRewardLore(String index) {
        List lore = switch (this.rewardStatus) {
            case "CLAIMED_REWARD" -> QRewards.languageConfig.getStringList("Language.Gui.Items.ClaimedReward.Lore");
            case "REWARD_READY" -> QRewards.languageConfig.getStringList("Language.Gui.Items.RewardReady.Lore");
            case "REWARD_NOT_READY" -> QRewards.languageConfig.getStringList("Language.Gui.Items.RewardNotReady.Lore");
            case "FUTURE_REWARD" -> QRewards.languageConfig.getStringList("Language.Gui.Items.FutureReward.Lore");
            default -> QRewards.languageConfig.getStringList("Language.Gui.Items.MissedReward.Lore");
        };
        ArrayList rewardsLore = new ArrayList(QRewards.rewardsConfig.getStringList("Rewards." + index + ".Lore"));
        ArrayList<String> legacyLore = new ArrayList<String>();
        for (String line : lore) {
            if (line.contains("[rewards]")) {
                for (String line2 : rewardsLore) {
                    legacyLore.add(QRewards.languageConfig.getString("Language.Gui.LineIndent") + line2);
                }
                continue;
            }
            if (line.contains("[timeUntilNextReward]")) {
                LocalDateTime now = LocalDateTime.now();
                LocalDateTime midnight = now.toLocalDate().atTime(LocalTime.MIDNIGHT).plusDays(1L);
                Duration duration = Duration.between(now, midnight);
                Object formattedTimeString = QRewards.languageConfig.getString("Language.Messages.Hours") + " " + QRewards.languageConfig.getString("Language.Messages.Minutes") + " " + QRewards.languageConfig.getString("Language.Messages.Seconds");
                formattedTimeString = ((String)formattedTimeString).replace("[hour]", String.valueOf(duration.toHours()));
                formattedTimeString = ((String)formattedTimeString).replace("[minute]", String.valueOf(duration.toMinutesPart()));
                formattedTimeString = ((String)formattedTimeString).replace("[second]", String.valueOf(duration.toSecondsPart()));
                legacyLore.add(line.replace("[timeUntilNextReward]", (CharSequence)formattedTimeString));
                continue;
            }
            legacyLore.add(line);
        }
        return StringUtils.loreColorize(legacyLore);
    }
}

