/*
 * Decompiled with CFR 0.152.
 */
package com.qrawless.qRewards.rewards;

import com.qrawless.qRewards.core.QRewards;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

public class RewardsLeaderboard {
    public static void updateTop10StreakLeaderboard() {
        QRewards.TOP10HighestStreak.clear();
        try (PreparedStatement statement = QRewards.QLib.getDatabase().getConnection().prepareStatement("SELECT player_name, streak FROM qrewards_players ORDER BY streak DESC LIMIT 10");
             ResultSet resultSet = statement.executeQuery();){
            while (resultSet.next()) {
                String playerName = resultSet.getString("player_name");
                int streak = resultSet.getInt("streak");
                QRewards.TOP10HighestStreak.put(playerName, streak);
            }
            if (QRewards.debug) {
                System.out.println("Highest Streak Leaderboard Updated:");
            }
            if (QRewards.debug) {
                for (Map.Entry<String, Integer> entry : QRewards.TOP10HighestStreak.entrySet()) {
                    if (!QRewards.debug) continue;
                    System.out.println("  " + entry.getKey() + ": " + String.valueOf(entry.getValue()));
                }
            }
        }
        catch (SQLException e) {
            System.err.println("Error updating top 10 streak leaderboard: " + e.getMessage());
        }
    }

    public static Map.Entry<String, Integer> getTopPlayerAtRank(int rank) {
        if (rank < 1 || rank > 10) {
            System.out.println("Ge\u00e7ersiz s\u0131ra numaras\u0131. S\u0131ra 1 ile 10 aras\u0131nda olmal\u0131d\u0131r.");
            return null;
        }
        Map<String, Integer> top10Players = QRewards.TOP10HighestStreak;
        if (top10Players.isEmpty() || top10Players.size() < rank) {
            return null;
        }
        int currentIndex = 0;
        for (Map.Entry<String, Integer> entry : top10Players.entrySet()) {
            if (currentIndex == rank - 1) {
                return entry;
            }
            ++currentIndex;
        }
        return null;
    }
}

