/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import nl.odalitadevelopments.menus.OdalitaMenus;
import nl.odalitadevelopments.menus.items.ItemProcessor;
import nl.odalitadevelopments.menus.listeners.InventoryListener;
import nl.odalitadevelopments.menus.listeners.InventoryPacketListener;
import nl.odalitadevelopments.menus.menu.MenuOpenerBuilder;
import nl.odalitadevelopments.menus.menu.MenuProcessor;
import nl.odalitadevelopments.menus.menu.MenuSession;
import nl.odalitadevelopments.menus.menu.cache.GlobalSessionCache;
import nl.odalitadevelopments.menus.menu.providers.MenuProvider;
import nl.odalitadevelopments.menus.menu.providers.MenuProviderLoader;
import nl.odalitadevelopments.menus.menu.providers.frame.MenuFrameProvider;
import nl.odalitadevelopments.menus.menu.providers.frame.MenuFrameProviderLoader;
import nl.odalitadevelopments.menus.menu.type.SupportedMenuTypes;
import nl.odalitadevelopments.menus.nms.OdalitaMenusNMS;
import nl.odalitadevelopments.menus.nms.utils.OdalitaLogger;
import nl.odalitadevelopments.menus.nms.utils.PaperHelper;
import nl.odalitadevelopments.menus.nms.utils.version.ProtocolVersion;
import nl.odalitadevelopments.menus.nms.v1_16_R3.OdalitaMenusNMS_v1_16_R5;
import nl.odalitadevelopments.menus.nms.v1_17_R1.OdalitaMenusNMS_v1_17_R1;
import nl.odalitadevelopments.menus.nms.v1_18_R2.OdalitaMenusNMS_v1_18_R2;
import nl.odalitadevelopments.menus.nms.v1_19_R3.OdalitaMenusNMS_v1_19_R3;
import nl.odalitadevelopments.menus.nms.v1_20_R1.OdalitaMenusNMS_v1_20_R1;
import nl.odalitadevelopments.menus.nms.v1_20_R2.OdalitaMenusNMS_v1_20_R2;
import nl.odalitadevelopments.menus.nms.v1_20_R3.OdalitaMenusNMS_v1_20_R3;
import nl.odalitadevelopments.menus.nms.v1_20_R4.OdalitaMenusNMS_v1_20_R4;
import nl.odalitadevelopments.menus.nms.v1_21_R1.OdalitaMenusNMS_v1_21_R1;
import nl.odalitadevelopments.menus.nms.v1_21_R2.OdalitaMenusNMS_v1_21_R2;
import nl.odalitadevelopments.menus.nms.v1_21_R2.OdalitaMenusNMS_v1_21_R3;
import nl.odalitadevelopments.menus.patterns.MenuPattern;
import nl.odalitadevelopments.menus.patterns.PatternContainer;
import nl.odalitadevelopments.menus.providers.ProvidersContainer;
import nl.odalitadevelopments.menus.tasks.MenuTasksProcessor;
import nl.odalitadevelopments.menus.utils.cooldown.CooldownContainer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class OdalitaMenusImpl
implements OdalitaMenus,
Listener {
    private static final Map<Plugin, OdalitaMenus> INSTANCES = new HashMap<Plugin, OdalitaMenus>();
    private final JavaPlugin javaPlugin;
    private final SupportedMenuTypes supportedMenuTypes;
    private final ItemProcessor itemProcessor;
    private final MenuProcessor menuProcessor;
    private final GlobalSessionCache globalSessionCache;
    private final PatternContainer patternContainer;
    private final ProvidersContainer providersContainer;
    private final CooldownContainer cooldownContainer;
    private final InventoryListener inventoryListener;
    private final BukkitTask menuTask;

    @NotNull
    static OdalitaMenus createInstance(@NotNull JavaPlugin javaPlugin) {
        if (!javaPlugin.getName().equals("OdalitaMenus") && Bukkit.getPluginManager().isPluginEnabled("OdalitaMenus")) {
            return INSTANCES.get(Bukkit.getPluginManager().getPlugin("OdalitaMenus"));
        }
        return new OdalitaMenusImpl(javaPlugin);
    }

    @NotNull
    static OdalitaMenus getInstance(@NotNull JavaPlugin javaPlugin) {
        OdalitaMenus instance = INSTANCES.get(javaPlugin);
        if (instance == null) {
            throw new IllegalStateException("OdalitaMenus is not initialized for this plugin! (JavaPlugin: " + javaPlugin.getName() + ")");
        }
        return instance;
    }

    static boolean hasInstance(@NotNull JavaPlugin javaPlugin) {
        return INSTANCES.containsKey(javaPlugin);
    }

    private OdalitaMenusImpl(JavaPlugin javaPlugin) {
        if (INSTANCES.containsKey(javaPlugin)) {
            throw new IllegalStateException("OdalitaMenus is already initialized for this plugin! (JavaPlugin: " + javaPlugin.getName() + ")");
        }
        this.initNMS();
        this.javaPlugin = javaPlugin;
        this.supportedMenuTypes = new SupportedMenuTypes();
        this.itemProcessor = new ItemProcessor();
        this.menuProcessor = new MenuProcessor(this, this.itemProcessor, this.supportedMenuTypes);
        this.globalSessionCache = new GlobalSessionCache();
        this.patternContainer = new PatternContainer();
        this.providersContainer = new ProvidersContainer(this);
        this.cooldownContainer = new CooldownContainer();
        this.inventoryListener = new InventoryListener(this, this.menuProcessor);
        new InventoryPacketListener(this, this.menuProcessor);
        javaPlugin.getServer().getPluginManager().registerEvents((Listener)this.inventoryListener, (Plugin)javaPlugin);
        javaPlugin.getServer().getPluginManager().registerEvents((Listener)this.globalSessionCache, (Plugin)javaPlugin);
        javaPlugin.getServer().getPluginManager().registerEvents((Listener)this.cooldownContainer, (Plugin)javaPlugin);
        javaPlugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)javaPlugin);
        this.menuTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)javaPlugin, (Runnable)new MenuTasksProcessor(this), 0L, 1L);
        INSTANCES.put((Plugin)javaPlugin, this);
    }

    private void initNMS() {
        ProtocolVersion serverVersion = ProtocolVersion.getServerVersion();
        if (serverVersion.isHigherOrEqual(ProtocolVersion.MINECRAFT_1_20_6) && !PaperHelper.IS_PAPER) {
            OdalitaLogger.error("OdalitaMenus requires Paper based server software to run on Minecraft 1.20.6 and higher!");
            return;
        }
        try {
            Class<?> harmNMSInstance = Class.forName("nl.odalitadevelopments.menus.nms.OdalitaMenusNMSInstance");
            OdalitaMenusNMS nms = switch (serverVersion) {
                case ProtocolVersion.MINECRAFT_1_21_4 -> new OdalitaMenusNMS_v1_21_R3();
                case ProtocolVersion.MINECRAFT_1_21_3 -> new OdalitaMenusNMS_v1_21_R2();
                case ProtocolVersion.MINECRAFT_1_21_1 -> new OdalitaMenusNMS_v1_21_R1();
                case ProtocolVersion.MINECRAFT_1_20_6 -> new OdalitaMenusNMS_v1_20_R4();
                case ProtocolVersion.MINECRAFT_1_20_4 -> new OdalitaMenusNMS_v1_20_R3();
                case ProtocolVersion.MINECRAFT_1_20_2 -> new OdalitaMenusNMS_v1_20_R2();
                case ProtocolVersion.MINECRAFT_1_20_1 -> new OdalitaMenusNMS_v1_20_R1();
                case ProtocolVersion.MINECRAFT_1_19_4 -> new OdalitaMenusNMS_v1_19_R3();
                case ProtocolVersion.MINECRAFT_1_18_2 -> new OdalitaMenusNMS_v1_18_R2();
                case ProtocolVersion.MINECRAFT_1_17_1 -> new OdalitaMenusNMS_v1_17_R1();
                case ProtocolVersion.MINECRAFT_1_16_5 -> new OdalitaMenusNMS_v1_16_R5();
                default -> throw new IllegalStateException("OdalitaMenus does not support this server version! (Versions supported: " + ProtocolVersion.MINECRAFT_1_16_5.format() + " - " + ProtocolVersion.latest().format() + ")");
            };
            Method method = harmNMSInstance.getDeclaredMethod("init", OdalitaMenusNMS.class);
            method.setAccessible(true);
            method.invoke(null, nms);
            method.setAccessible(false);
        }
        catch (Exception exception) {
            OdalitaLogger.error(exception);
            Bukkit.getServer().shutdown();
        }
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull Player> getPlayersWithOpenMenu() {
        return this.menuProcessor.getPlayersWithOpenMenu();
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull Player> getPlayersWithOpenMenu(@NotNull String id) {
        return this.menuProcessor.getPlayersWithOpenMenu(id);
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull MenuSession> getOpenMenuSessions() {
        return this.menuProcessor.getOpenMenuSessions();
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull MenuSession> getOpenMenuSessions(@NotNull String id) {
        return this.menuProcessor.getOpenMenuSessions(id);
    }

    @Override
    @Nullable
    public MenuSession getOpenMenuSession(@NotNull Player player) {
        return this.menuProcessor.getOpenMenuSession(player);
    }

    @Override
    public <P extends MenuProvider> void registerProviderLoader(@NotNull Class<P> providerClass, @NotNull MenuProviderLoader<P> loader) {
        this.menuProcessor.registerProviderLoader(providerClass, loader);
    }

    @Override
    public <P extends MenuProvider> boolean isProviderLoaderRegistered(@NotNull Class<P> providerClass) {
        return this.menuProcessor.isProviderLoaderRegistered(providerClass);
    }

    @Override
    public <P extends MenuFrameProvider> void registerFrameProviderLoader(@NotNull Class<P> providerClass, @NotNull MenuFrameProviderLoader<P> loader) {
        this.menuProcessor.getMenuFrameProcessor().registerFrameProviderLoader(providerClass, loader);
    }

    @Override
    public <P extends MenuFrameProvider> boolean isFrameProviderLoaderRegistered(@NotNull Class<P> providerClass) {
        return this.menuProcessor.getMenuFrameProcessor().isFrameProviderLoaderRegistered(providerClass);
    }

    @Override
    public void openMenu(@NotNull MenuProvider menuProvider, @NotNull Player player) {
        this.menuProcessor.openMenu(menuProvider, player);
    }

    @Override
    @NotNull
    public <P extends MenuProvider> MenuOpenerBuilder openMenuBuilder(@NotNull P menuProvider, @NotNull Player player) {
        return this.menuProcessor.openMenuBuilder(menuProvider, player);
    }

    @Override
    public <CacheType, T extends MenuPattern<CacheType>> void registerPattern(@NotNull T pattern) {
        this.patternContainer.registerPattern(pattern);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    private void onPluginDisable(PluginDisableEvent event) {
        if (this.javaPlugin.equals((Object)event.getPlugin())) {
            this.menuTask.cancel();
            for (Player player : this.menuProcessor.getPlayersWithOpenMenu()) {
                player.closeInventory();
            }
            this.providersContainer.close(this);
            HandlerList.unregisterAll((Listener)this.inventoryListener);
            HandlerList.unregisterAll((Listener)this.globalSessionCache);
            HandlerList.unregisterAll((Listener)this.cooldownContainer);
            HandlerList.unregisterAll((Listener)this);
            INSTANCES.remove(this.javaPlugin);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onServerCommand(ServerCommandEvent event) {
        String command = event.getCommand().split(" ")[0].toLowerCase();
        if (command.endsWith("stop") || command.endsWith("restart") || command.endsWith("reload") || command.endsWith("rl")) {
            for (Player player : this.menuProcessor.getPlayersWithOpenMenu()) {
                player.closeInventory();
            }
        }
    }

    @Override
    public JavaPlugin getJavaPlugin() {
        return this.javaPlugin;
    }

    @Override
    public SupportedMenuTypes getSupportedMenuTypes() {
        return this.supportedMenuTypes;
    }

    @Override
    public ItemProcessor getItemProcessor() {
        return this.itemProcessor;
    }

    @Override
    public MenuProcessor getMenuProcessor() {
        return this.menuProcessor;
    }

    @Override
    public GlobalSessionCache getGlobalSessionCache() {
        return this.globalSessionCache;
    }

    @Override
    public PatternContainer getPatternContainer() {
        return this.patternContainer;
    }

    @Override
    public ProvidersContainer getProvidersContainer() {
        return this.providersContainer;
    }

    @Override
    public CooldownContainer getCooldownContainer() {
        return this.cooldownContainer;
    }
}

