/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.contents;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import nl.odalitadevelopments.menus.contents.MenuContentsActions;
import nl.odalitadevelopments.menus.contents.MenuContentsEvents;
import nl.odalitadevelopments.menus.contents.MenuContentsImpl;
import nl.odalitadevelopments.menus.contents.MenuContentsScheduler;
import nl.odalitadevelopments.menus.contents.MenuFrameData;
import nl.odalitadevelopments.menus.contents.placeableitem.PlaceableItemsCloseAction;
import nl.odalitadevelopments.menus.contents.pos.SlotPos;
import nl.odalitadevelopments.menus.items.MenuItem;
import nl.odalitadevelopments.menus.items.PageUpdatableItem;
import nl.odalitadevelopments.menus.iterators.MenuIterator;
import nl.odalitadevelopments.menus.iterators.MenuIteratorType;
import nl.odalitadevelopments.menus.iterators.MenuObjectIterator;
import nl.odalitadevelopments.menus.menu.MenuSession;
import nl.odalitadevelopments.menus.menu.cache.MenuSessionCache;
import nl.odalitadevelopments.menus.menu.providers.frame.MenuFrameProvider;
import nl.odalitadevelopments.menus.menu.type.MenuType;
import nl.odalitadevelopments.menus.pagination.PaginationBuilder;
import nl.odalitadevelopments.menus.patterns.DirectionPattern;
import nl.odalitadevelopments.menus.patterns.IteratorPattern;
import nl.odalitadevelopments.menus.patterns.MenuPattern;
import nl.odalitadevelopments.menus.patterns.PatternCache;
import nl.odalitadevelopments.menus.scrollable.ScrollableBuilder;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface MenuContents {
    @ApiStatus.Internal
    public static MenuContents create(@NotNull MenuSession menuSession) {
        return new MenuContentsImpl(menuSession);
    }

    @NotNull
    public MenuSession menuSession();

    @NotNull
    public MenuContentsScheduler scheduler();

    @NotNull
    public MenuContentsActions actions();

    @NotNull
    public MenuContentsEvents events();

    @Nullable
    public MenuFrameData menuFrameData();

    public void set(@NotNull SlotPos var1, @NotNull MenuItem var2, boolean var3);

    public void set(@NotNull SlotPos var1, @NotNull MenuItem var2);

    public void set(int var1, int var2, @NotNull MenuItem var3, boolean var4);

    public void set(int var1, int var2, @NotNull MenuItem var3);

    public void set(int var1, @NotNull MenuItem var2, boolean var3);

    public void set(int var1, @NotNull MenuItem var2);

    public void add(@NotNull MenuItem var1);

    @NotNull
    public @NotNull Optional<@NotNull SlotPos> firstEmptySlot();

    public void clear(@NotNull SlotPos var1);

    public void clear(int var1, int var2);

    public void clear(int var1);

    public boolean isEmpty(@NotNull SlotPos var1);

    public boolean isEmpty(int var1, int var2);

    public boolean isEmpty(int var1);

    public void fillRow(int var1, @NotNull MenuItem var2);

    public void fillColumn(int var1, @NotNull MenuItem var2);

    public void fillRectangle(@NotNull SlotPos var1, @NotNull SlotPos var2, @NotNull MenuItem var3);

    public void fillRectangle(int var1, int var2, int var3, int var4, @NotNull MenuItem var5);

    public void fillRectangle(int var1, int var2, @NotNull MenuItem var3);

    public void fillBorders(@NotNull MenuItem var1);

    public void fill(@NotNull MenuItem var1);

    public void setRefreshable(@NotNull SlotPos var1, @NotNull @NotNull Supplier<@NotNull MenuItem> var2, boolean var3);

    public void setRefreshable(@NotNull SlotPos var1, @NotNull @NotNull Supplier<@NotNull MenuItem> var2);

    public void setRefreshable(int var1, int var2, @NotNull @NotNull Supplier<@NotNull MenuItem> var3, boolean var4);

    public void setRefreshable(int var1, int var2, @NotNull @NotNull Supplier<@NotNull MenuItem> var3);

    public void setRefreshable(int var1, @NotNull @NotNull Supplier<@NotNull MenuItem> var2, boolean var3);

    public void setRefreshable(int var1, @NotNull @NotNull Supplier<@NotNull MenuItem> var2);

    public void refreshItem(@NotNull SlotPos var1);

    public void refreshItem(int var1, int var2);

    public void refreshItem(int var1);

    public void refreshItems(SlotPos ... var1);

    public void refreshItems(int ... var1);

    public void setDisplay(@NotNull SlotPos var1, @NotNull ItemStack var2);

    public void setDisplay(int var1, int var2, @NotNull ItemStack var3);

    public void setDisplay(int var1, @NotNull ItemStack var2);

    public void setDisplay(@NotNull SlotPos var1, @NotNull Material var2);

    public void setDisplay(int var1, int var2, @NotNull Material var3);

    public void setDisplay(int var1, @NotNull Material var2);

    public void setDisplay(@NotNull SlotPos var1, @NotNull Material var2, @NotNull String var3);

    public void setDisplay(int var1, int var2, @NotNull Material var3, @NotNull String var4);

    public void setDisplay(int var1, @NotNull Material var2, @NotNull String var3);

    public void setClickable(@NotNull SlotPos var1, @NotNull ItemStack var2, @NotNull @NotNull Consumer<@NotNull InventoryClickEvent> var3);

    public void setClickable(int var1, int var2, @NotNull ItemStack var3, @NotNull @NotNull Consumer<@NotNull InventoryClickEvent> var4);

    public void setClickable(int var1, @NotNull ItemStack var2, @NotNull @NotNull Consumer<@NotNull InventoryClickEvent> var3);

    public void setClickable(@NotNull SlotPos var1, @NotNull Material var2, @NotNull @NotNull Consumer<@NotNull InventoryClickEvent> var3);

    public void setClickable(int var1, int var2, @NotNull Material var3, @NotNull @NotNull Consumer<@NotNull InventoryClickEvent> var4);

    public void setClickable(int var1, @NotNull Material var2, @NotNull @NotNull Consumer<@NotNull InventoryClickEvent> var3);

    public void setClickable(@NotNull SlotPos var1, @NotNull Material var2, @NotNull String var3, @NotNull @NotNull Consumer<@NotNull InventoryClickEvent> var4);

    public void setClickable(int var1, int var2, @NotNull Material var3, @NotNull String var4, @NotNull @NotNull Consumer<@NotNull InventoryClickEvent> var5);

    public void setClickable(int var1, @NotNull Material var2, @NotNull String var3, @NotNull @NotNull Consumer<@NotNull InventoryClickEvent> var4);

    public void setUpdatable(@NotNull SlotPos var1, @NotNull @NotNull Supplier<@NotNull ItemStack> var2, @NotNull @NotNull Consumer<@NotNull InventoryClickEvent> var3);

    public void setUpdatable(int var1, int var2, @NotNull @NotNull Supplier<@NotNull ItemStack> var3, @NotNull @NotNull Consumer<@NotNull InventoryClickEvent> var4);

    public void setUpdatable(int var1, @NotNull @NotNull Supplier<@NotNull ItemStack> var2, @NotNull @NotNull Consumer<@NotNull InventoryClickEvent> var3);

    public void setUpdatable(@NotNull SlotPos var1, @NotNull @NotNull Supplier<@NotNull ItemStack> var2, @NotNull @NotNull Consumer<@NotNull InventoryClickEvent> var3, int var4);

    public void setUpdatable(int var1, int var2, @NotNull @NotNull Supplier<@NotNull ItemStack> var3, @NotNull @NotNull Consumer<@NotNull InventoryClickEvent> var4, int var5);

    public void setUpdatable(int var1, @NotNull @NotNull Supplier<@NotNull ItemStack> var2, @NotNull @NotNull Consumer<@NotNull InventoryClickEvent> var3, int var4);

    public void setUpdatable(@NotNull SlotPos var1, @NotNull @NotNull Supplier<@NotNull ItemStack> var2, int var3);

    public void setUpdatable(int var1, int var2, @NotNull @NotNull Supplier<@NotNull ItemStack> var3, int var4);

    public void setUpdatable(int var1, @NotNull @NotNull Supplier<@NotNull ItemStack> var2, int var3);

    public void setUpdatable(@NotNull SlotPos var1, @NotNull @NotNull Supplier<@NotNull ItemStack> var2);

    public void setUpdatable(int var1, int var2, @NotNull @NotNull Supplier<@NotNull ItemStack> var3);

    public void setUpdatable(int var1, @NotNull @NotNull Supplier<@NotNull ItemStack> var2);

    @NotNull
    public MenuIterator createIterator(@NotNull String var1, @NotNull MenuIteratorType var2, int var3, int var4);

    public void createSimpleIterator(@NotNull MenuIteratorType var1, int var2, int var3, @NotNull @NotNull List<@NotNull MenuItem> var4, int ... var5);

    @NotNull
    public <T> MenuObjectIterator<T> createObjectIterator(@NotNull MenuIteratorType var1, int var2, int var3, @NotNull Class<T> var4, @NotNull @NotNull Function<@NotNull T, @NotNull MenuItem> var5);

    public <C extends PatternCache<T>, T> void createPatternIterator(@NotNull MenuPattern<C> var1, @NotNull @NotNull List<@NotNull MenuItem> var2);

    public void createPatternIterator(@NotNull Class<? extends IteratorPattern> var1, @NotNull @NotNull List<@NotNull MenuItem> var2);

    public void createDirectionsPatternIterator(@NotNull Class<? extends DirectionPattern> var1, @NotNull @NotNull List<@NotNull MenuItem> var2);

    public void registerPlaceableItemSlots(int ... var1);

    public void allowPlaceableItemShiftClick(boolean var1);

    public void allowPlaceableItemDrag(boolean var1);

    public void setForcedPlaceableItem(@NotNull SlotPos var1, @NotNull ItemStack var2);

    public void setForcedPlaceableItem(int var1, int var2, @NotNull ItemStack var3);

    public void setForcedPlaceableItem(int var1, @NotNull ItemStack var2);

    public void placeableItemsCloseAction(@NotNull PlaceableItemsCloseAction var1);

    @NotNull
    public @NotNull Optional<@NotNull SlotPos> firstEmptyPlaceableItemSlot();

    @NotNull
    public Map<Integer, ItemStack> getPlaceableItems();

    @NotNull
    public PaginationBuilder.ItemPaginationBuilder pagination(@NotNull String var1, int var2, @NotNull MenuIterator var3);

    @NotNull
    public <T> PaginationBuilder.ObjectPaginationBuilder<T> pagination(@NotNull String var1, int var2, @NotNull MenuObjectIterator<T> var3);

    @NotNull
    public PaginationBuilder pagination(@NotNull String var1, int var2);

    @NotNull
    public ScrollableBuilder scrollable(@NotNull String var1, int var2, int var3);

    public void setPageSwitchUpdateItem(@NotNull SlotPos var1, @NotNull @NotNull Supplier<@NotNull PageUpdatableItem> var2);

    public void setPageSwitchUpdateItem(int var1, int var2, @NotNull @NotNull Supplier<@NotNull PageUpdatableItem> var3);

    public void setPageSwitchUpdateItem(int var1, @NotNull @NotNull Supplier<@NotNull PageUpdatableItem> var2);

    public <F extends MenuFrameProvider> void registerFrame(@NotNull String var1, @NotNull SlotPos var2, @NotNull Class<F> var3);

    public <F extends MenuFrameProvider> void registerFrame(@NotNull String var1, int var2, int var3, @NotNull Class<F> var4);

    public <F extends MenuFrameProvider> void registerFrame(@NotNull String var1, int var2, @NotNull Class<F> var3);

    public boolean loadFrame(@NotNull String var1, Object ... var2);

    public void unloadFrame(@NotNull String var1);

    public void registerFrameOverlaySlots(SlotPos ... var1);

    public void registerFrameOverlaySlots(int ... var1);

    @Nullable
    public String loadedFrameId();

    @NotNull
    public MenuSessionCache cache();

    public <T> T cache(@NotNull String var1, T var2);

    public <T> T cache(@NotNull String var1);

    @NotNull
    public MenuContents setCache(@NotNull String var1, @NotNull Object var2);

    @NotNull
    public MenuContents pruneCache(@NotNull String var1);

    public void setGlobalCacheKey(@NotNull String var1);

    public void setId(@NotNull String var1);

    public void setTitle(@NotNull String var1);

    public void setMenuType(@NotNull MenuType var1);

    public void closeInventory(@NotNull Player var1, @NotNull PlaceableItemsCloseAction var2);

    public int maxRows();

    public int maxColumns();
}

