/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.contents;

import java.util.Map;
import nl.odalitadevelopments.menus.contents.MenuContentsImpl;
import nl.odalitadevelopments.menus.contents.MenuContentsScheduler;
import nl.odalitadevelopments.menus.contents.MenuTask;
import org.jetbrains.annotations.NotNull;

final class MenuContentsSchedulerImpl
implements MenuContentsScheduler {
    private final MenuContentsImpl menuContents;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public MenuTask delay(@NotNull String id, @NotNull Runnable runnable, int ticksDelay, int ticksPeriod, int runTimes) {
        if (ticksDelay < 0 || ticksPeriod < 0) {
            throw new IllegalArgumentException("Delay, period must be positive");
        }
        Map<String, MenuTask> map = this.menuContents.cache.getTasks();
        synchronized (map) {
            runTimes = Math.max(runTimes, 0);
            if (this.menuContents.cache.getTasks().containsKey(id)) {
                throw new IllegalArgumentException("Task with id '" + id + "' already exists");
            }
            MenuTask task = new MenuTask(this, id, runnable, ticksDelay, ticksPeriod, runTimes);
            this.menuContents.cache.getTasks().put(task.getId(), task);
            return task;
        }
    }

    @Override
    @NotNull
    public MenuTask delay(@NotNull String id, @NotNull Runnable runnable, int ticksDelay, int ticksPeriod) {
        return this.delay(id, runnable, ticksDelay, ticksPeriod, 0);
    }

    @Override
    @NotNull
    public MenuTask delay(@NotNull String id, @NotNull Runnable runnable, int ticksDelay) {
        return this.delay(id, runnable, ticksDelay, 0, 1);
    }

    @Override
    @NotNull
    public MenuTask schedule(@NotNull String id, @NotNull Runnable runnable, int ticksPeriod, int runTimes) {
        return this.delay(id, runnable, 0, ticksPeriod, runTimes);
    }

    @Override
    @NotNull
    public MenuTask schedule(@NotNull String id, @NotNull Runnable runnable, int ticksPeriod) {
        return this.schedule(id, runnable, ticksPeriod, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRunning(@NotNull String id) {
        Map<String, MenuTask> map = this.menuContents.cache.getTasks();
        synchronized (map) {
            return this.menuContents.cache.getTasks().containsKey(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(@NotNull String id) {
        Map<String, MenuTask> map = this.menuContents.cache.getTasks();
        synchronized (map) {
            this.menuContents.cache.getTasks().remove(id);
        }
    }

    public MenuContentsSchedulerImpl(MenuContentsImpl menuContents) {
        this.menuContents = menuContents;
    }
}

