/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.contents.pos;

import nl.odalitadevelopments.menus.contents.MenuFrameData;
import nl.odalitadevelopments.menus.contents.pos.SlotPosition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SlotPos
extends SlotPosition {
    @NotNull
    public static SlotPos of(int row, int column) {
        return new SlotPos(row, column);
    }

    @NotNull
    public static SlotPos of(int slot) {
        return new SlotPos(slot);
    }

    @NotNull
    public static SlotPos of(int height, int width, int row, int column) {
        return new SlotPos(height, width, row, column);
    }

    @NotNull
    public static SlotPos of(int height, int width, int slot) {
        return new SlotPos(height, width, slot);
    }

    private SlotPos(int height, int width, int row, int column) {
        super(height, width, row, column);
    }

    private SlotPos(int row, int column) {
        this(6, 9, row, column);
    }

    private SlotPos(int height, int width, int slot) {
        super(height, width, slot);
    }

    private SlotPos(int slot) {
        this(6, 9, slot);
    }

    @NotNull
    public SlotPos convertTo(int height, int width) {
        if (this.createdFromSlot) {
            return new SlotPos(height, width, this.slot);
        }
        return new SlotPos(height, width, this.row, this.column);
    }

    @NotNull
    public SlotPos convertFromFrame(int height, int width, @Nullable MenuFrameData frameData) {
        if (frameData == null) {
            return this;
        }
        int startRow = frameData.startRow();
        int startColumn = frameData.startColumn();
        int startSlot = startRow * width + startColumn;
        int slot = startSlot + this.row * width + this.column;
        return new SlotPos(height, width, slot);
    }
}

