/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.contents.pos;

import com.google.common.base.Preconditions;

public abstract class SlotPosition {
    protected final int height;
    protected final int width;
    protected int row;
    protected int column;
    protected int slot;
    protected boolean createdFromSlot;

    protected SlotPosition(int height, int width, int row, int column) {
        Preconditions.checkArgument((height >= 0 ? 1 : 0) != 0, (Object)"height must be greater than 0");
        Preconditions.checkArgument((width >= 0 ? 1 : 0) != 0, (Object)"width must be greater than 0");
        Preconditions.checkArgument((row >= 0 ? 1 : 0) != 0, (Object)"row must be greater than 0");
        Preconditions.checkArgument((column >= 0 ? 1 : 0) != 0, (Object)"column must be greater than 0");
        this.height = height;
        this.width = width;
        this.row = row;
        this.column = column;
        this.slot = row * this.width + column;
        this.createdFromSlot = false;
    }

    protected SlotPosition(int height, int width, int slot) {
        Preconditions.checkArgument((height >= 0 ? 1 : 0) != 0, (Object)"height must be greater than 0");
        Preconditions.checkArgument((width >= 0 ? 1 : 0) != 0, (Object)"width must be greater than 0");
        Preconditions.checkArgument((slot >= 0 ? 1 : 0) != 0, (Object)"slot must be greater than 0");
        this.height = height;
        this.width = width;
        this.slot = slot;
        this.row = this.width == 0 ? slot : slot / this.width;
        this.column = slot - this.width * this.row;
        this.createdFromSlot = true;
    }

    public String toString() {
        return "SlotPosition{height=" + this.height + ", width=" + this.width + ", row=" + this.row + ", column=" + this.column + ", slot=" + this.slot + ", createdFromSlot=" + this.createdFromSlot + "}";
    }

    public boolean equals(Object object) {
        if (object instanceof SlotPosition) {
            SlotPosition slotPosition = (SlotPosition)object;
            return slotPosition.getHeight() == this.height && slotPosition.getWidth() == this.width && slotPosition.getRow() == this.row && slotPosition.getColumn() == this.column;
        }
        return false;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public int getSlot() {
        return this.slot;
    }

    public boolean isCreatedFromSlot() {
        return this.createdFromSlot;
    }
}

