/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.items;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import nl.odalitadevelopments.menus.contents.MenuContents;
import nl.odalitadevelopments.menus.contents.pos.SlotPos;
import nl.odalitadevelopments.menus.items.MenuItem;
import nl.odalitadevelopments.menus.iterators.AbstractMenuIterator;
import nl.odalitadevelopments.menus.menu.MenuSession;
import nl.odalitadevelopments.menus.menu.type.SupportedMenuType;
import nl.odalitadevelopments.menus.pagination.IPagination;
import nl.odalitadevelopments.menus.pagination.ObjectPagination;
import nl.odalitadevelopments.menus.scrollable.Scrollable;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.ApiStatus;

public final class ItemProcessor {
    @ApiStatus.Internal
    public void initializeItems(MenuSession menuSession, MenuContents menuContents) {
        SupportedMenuType menuType = menuSession.getMenuType();
        Inventory inventory = menuSession.getInventory();
        MenuItem[][] contents = menuSession.contents;
        for (IPagination<?, ?> pagination : menuSession.getCache().getPaginationMap().values()) {
            if (pagination instanceof ObjectPagination) continue;
            List<Supplier<MenuItem>> itemsOnPage = pagination.getItemsOnPage();
            if (itemsOnPage.isEmpty()) {
                pagination.setInitialized();
                continue;
            }
            for (Supplier<MenuItem> supplier : itemsOnPage) {
                int slot;
                MenuItem menuItem;
                if (supplier == null || (menuItem = supplier.get()) == null || inventory.getItem(slot = ((AbstractMenuIterator)pagination.iterator()).getSlot()) != null) continue;
                menuContents.set(slot, menuItem);
                ((AbstractMenuIterator)pagination.iterator()).next();
            }
            pagination.setInitialized();
        }
        for (Scrollable scrollable : menuSession.getCache().getScrollableMap().values()) {
            Map<Integer, Supplier<MenuItem>> pageItems = scrollable.getPageItems();
            if (pageItems.isEmpty()) {
                scrollable.setInitialized();
                continue;
            }
            for (Map.Entry entry : pageItems.entrySet()) {
                MenuItem menuItem;
                int slot = (Integer)entry.getKey();
                Supplier menuItemSupplier = (Supplier)entry.getValue();
                if (menuItemSupplier == null || (menuItem = (MenuItem)menuItemSupplier.get()) == null || inventory.getItem(slot) != null) continue;
                menuContents.set(slot, menuItem);
            }
            scrollable.setInitialized();
        }
        for (int row = 0; row < menuSession.getRows(); ++row) {
            for (int column = 0; column < menuSession.getColumns(); ++column) {
                MenuItem menuItem = contents[row][column];
                if (menuItem == null) continue;
                int slot = SlotPos.of(menuType.maxRows(), menuType.maxColumns(), row, column).getSlot();
                inventory.setItem(slot, menuItem.provideItem(menuSession.getInstance(), menuSession.getMenuContents()));
                if (menuSession.isHasUpdatableItems() || !menuItem.isUpdatable()) continue;
                menuSession.setHasUpdatableItems(true);
            }
        }
    }
}

