/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.items;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import nl.odalitadevelopments.menus.OdalitaMenus;
import nl.odalitadevelopments.menus.contents.MenuContents;
import nl.odalitadevelopments.menus.providers.providers.MenuItemDataProvider;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class MenuItem {
    private static final AtomicInteger ID_COUNTER = new AtomicInteger(0);
    private final int id = ID_COUNTER.get() >= 10000 ? ID_COUNTER.getAndSet(0) : ID_COUNTER.getAndIncrement();

    @NotNull
    protected abstract ItemStack getItemStack(@NotNull OdalitaMenus var1, @NotNull MenuContents var2);

    @NotNull
    public final ItemStack provideItem(@NotNull OdalitaMenus instance, @NotNull MenuContents contents) {
        ItemStack itemStack = this.getItemStack(instance, contents);
        MenuItemDataProvider menuItemDataProvider = instance.getProvidersContainer().getMenuItemDataProvider();
        if (menuItemDataProvider != null) {
            itemStack = menuItemDataProvider.provideData(contents.menuSession(), itemStack);
        }
        return itemStack;
    }

    @NotNull
    public abstract Consumer<InventoryClickEvent> onClick(@NotNull OdalitaMenus var1, @NotNull MenuContents var2);

    public boolean isUpdatable() {
        return false;
    }

    public int getUpdateTicks() {
        return -1;
    }

    public final int getId() {
        return this.id;
    }
}

