/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.items;

import java.util.function.Consumer;
import java.util.function.Supplier;
import nl.odalitadevelopments.menus.OdalitaMenus;
import nl.odalitadevelopments.menus.contents.MenuContents;
import nl.odalitadevelopments.menus.items.MenuItem;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class UpdatableItem
extends MenuItem {
    private final Supplier<ItemStack> itemStackSupplier;
    private final Consumer<InventoryClickEvent> clickHandler;
    private final int updateTicks;

    @NotNull
    public static UpdatableItem of(@NotNull @NotNull Supplier<@NotNull ItemStack> itemStackSupplier, @NotNull @NotNull Consumer<@NotNull InventoryClickEvent> clickHandler, int updateTicks) {
        return new UpdatableItem(itemStackSupplier, clickHandler, updateTicks);
    }

    @NotNull
    public static UpdatableItem of(@NotNull @NotNull Supplier<@NotNull ItemStack> itemStackSupplier, @NotNull @NotNull Consumer<@NotNull InventoryClickEvent> clickHandler) {
        return new UpdatableItem(itemStackSupplier, clickHandler);
    }

    @NotNull
    public static UpdatableItem of(@NotNull @NotNull Supplier<@NotNull ItemStack> itemStackSupplier, int updateTicks) {
        return new UpdatableItem(itemStackSupplier, updateTicks);
    }

    @NotNull
    public static UpdatableItem of(@NotNull @NotNull Supplier<@NotNull ItemStack> itemStackSupplier) {
        return new UpdatableItem(itemStackSupplier);
    }

    private UpdatableItem(Supplier<ItemStack> itemStackSupplier, Consumer<InventoryClickEvent> clickHandler) {
        this(itemStackSupplier, clickHandler, 20);
    }

    private UpdatableItem(Supplier<ItemStack> itemStackSupplier, int updateTicks) {
        this(itemStackSupplier, null, updateTicks);
    }

    private UpdatableItem(Supplier<ItemStack> itemStackSupplier) {
        this(itemStackSupplier, null);
    }

    @Override
    @NotNull
    protected ItemStack getItemStack(@NotNull OdalitaMenus instance, @NotNull MenuContents contents) {
        return this.itemStackSupplier.get();
    }

    @Override
    @NotNull
    public Consumer<InventoryClickEvent> onClick(@NotNull OdalitaMenus instance, @NotNull MenuContents contents) {
        return this.clickHandler == null ? event -> {} : this.clickHandler;
    }

    @Override
    public boolean isUpdatable() {
        return true;
    }

    @Override
    public int getUpdateTicks() {
        return this.updateTicks;
    }

    private UpdatableItem(Supplier<ItemStack> itemStackSupplier, Consumer<InventoryClickEvent> clickHandler, int updateTicks) {
        this.itemStackSupplier = itemStackSupplier;
        this.clickHandler = clickHandler;
        this.updateTicks = updateTicks;
    }
}

