/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.items.buttons;

import java.util.function.Consumer;
import java.util.function.Function;
import nl.odalitadevelopments.menus.OdalitaMenus;
import nl.odalitadevelopments.menus.contents.MenuContents;
import nl.odalitadevelopments.menus.items.MenuItem;
import nl.odalitadevelopments.menus.menu.MenuOpenerBuilder;
import nl.odalitadevelopments.menus.menu.MenuProcessor;
import nl.odalitadevelopments.menus.menu.providers.MenuProvider;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class OpenMenuItem<P extends MenuProvider>
extends MenuItem {
    protected final P menuProvider;
    protected final Function<MenuOpenerBuilder, MenuOpenerBuilder> builderFunction;
    protected ItemStack itemStack;

    @NotNull
    public static <P extends MenuProvider> OpenMenuItem<P> of(@NotNull ItemStack itemStack, @NotNull P menuProvider, @NotNull @NotNull Function<@NotNull MenuOpenerBuilder, @NotNull MenuOpenerBuilder> builderFunction) {
        return new OpenMenuItem<P>(itemStack, menuProvider, builderFunction);
    }

    @NotNull
    public static <P extends MenuProvider> OpenMenuItem<P> of(@NotNull ItemStack itemStack, @NotNull P menuProvider) {
        return new OpenMenuItem<P>(itemStack, menuProvider, builder -> builder);
    }

    protected OpenMenuItem(ItemStack itemStack, P menuProvider, Function<MenuOpenerBuilder, MenuOpenerBuilder> builderFunction) {
        this.menuProvider = menuProvider;
        this.builderFunction = builderFunction;
        this.itemStack = itemStack;
    }

    protected OpenMenuItem(P menuProvider, Function<MenuOpenerBuilder, MenuOpenerBuilder> builderFunction) {
        this(null, menuProvider, builderFunction);
    }

    @Override
    @NotNull
    protected ItemStack getItemStack(@NotNull OdalitaMenus instance, @NotNull MenuContents contents) {
        if (this.itemStack == null) {
            this.itemStack = new ItemStack(Material.AIR);
        }
        return this.itemStack;
    }

    @Override
    @NotNull
    public Consumer<InventoryClickEvent> onClick(@NotNull OdalitaMenus instance, @NotNull MenuContents contents) {
        return event -> {
            HumanEntity patt0$temp = event.getWhoClicked();
            if (!(patt0$temp instanceof Player)) {
                return;
            }
            Player player = (Player)patt0$temp;
            MenuProcessor menuProcessor = instance.getMenuProcessor();
            MenuOpenerBuilder builder = menuProcessor.openMenuBuilder(this.menuProvider, player);
            this.builderFunction.apply(builder).open();
        };
    }
}

