/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.items.buttons;

import java.util.function.Consumer;
import nl.odalitadevelopments.menus.OdalitaMenus;
import nl.odalitadevelopments.menus.contents.MenuContents;
import nl.odalitadevelopments.menus.items.PageUpdatableItem;
import nl.odalitadevelopments.menus.pagination.IPagination;
import nl.odalitadevelopments.menus.providers.providers.DefaultItemProvider;
import nl.odalitadevelopments.menus.utils.cooldown.Cooldown;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class PageItem
extends PageUpdatableItem {
    private final Type type;
    private final IPagination<?, ?> pagination;
    private final boolean showOnFirstOrLastPage;
    private final ItemStack itemStack;

    @NotNull
    public static PageItem previous(@NotNull IPagination<?, ?> pagination, @NotNull ItemStack itemStack, boolean showOnFirstPage) {
        return new PageItem(Type.PREVIOUS, pagination, itemStack, showOnFirstPage);
    }

    @NotNull
    public static PageItem previous(@NotNull IPagination<?, ?> pagination, boolean showOnFirstPage) {
        return new PageItem(Type.PREVIOUS, pagination, showOnFirstPage);
    }

    @NotNull
    public static PageItem previous(@NotNull IPagination<?, ?> pagination, @NotNull ItemStack itemStack) {
        return new PageItem(Type.PREVIOUS, pagination, itemStack, false);
    }

    @NotNull
    public static PageItem previous(@NotNull IPagination<?, ?> pagination) {
        return new PageItem(Type.PREVIOUS, pagination, false);
    }

    @NotNull
    public static PageItem next(@NotNull IPagination<?, ?> pagination, @NotNull ItemStack itemStack, boolean showOnLastPage) {
        return new PageItem(Type.NEXT, pagination, itemStack, showOnLastPage);
    }

    @NotNull
    public static PageItem next(@NotNull IPagination<?, ?> pagination, boolean showOnLastPage) {
        return new PageItem(Type.NEXT, pagination, showOnLastPage);
    }

    @NotNull
    public static PageItem next(@NotNull IPagination<?, ?> pagination, @NotNull ItemStack itemStack) {
        return new PageItem(Type.NEXT, pagination, itemStack, false);
    }

    @NotNull
    public static PageItem next(@NotNull IPagination<?, ?> pagination) {
        return new PageItem(Type.NEXT, pagination, false);
    }

    private PageItem(Type type, IPagination<?, ?> pagination, ItemStack itemStack, boolean showOnFirstOrLastPage) {
        this.type = type;
        this.pagination = pagination;
        this.itemStack = itemStack;
        this.showOnFirstOrLastPage = showOnFirstOrLastPage;
    }

    private PageItem(Type type, IPagination<?, ?> pagination, boolean showOnFirstOrLastPage) {
        this(type, pagination, null, showOnFirstOrLastPage);
    }

    @Override
    @NotNull
    protected ItemStack getItemStack(@NotNull OdalitaMenus instance, @NotNull MenuContents contents) {
        if (!this.showOnFirstOrLastPage && !this.canBeUsed()) {
            return new ItemStack(Material.AIR);
        }
        if (this.itemStack == null) {
            DefaultItemProvider defaultItemProvider = instance.getProvidersContainer().getDefaultItemProvider();
            return switch (this.type.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> defaultItemProvider.previousPageItem(this.pagination);
                case 1 -> defaultItemProvider.nextPageItem(this.pagination);
            };
        }
        return this.itemStack;
    }

    @Override
    @NotNull
    public Consumer<InventoryClickEvent> onClick(@NotNull OdalitaMenus instance, @NotNull MenuContents contents) {
        return event -> {
            HumanEntity patt0$temp = event.getWhoClicked();
            if (!(patt0$temp instanceof Player)) {
                return;
            }
            Player player = (Player)patt0$temp;
            Cooldown cooldown = instance.getProvidersContainer().getCooldownProvider().pageCooldown();
            if (cooldown != null && instance.getCooldownContainer().checkAndCreate(player.getUniqueId(), "INTERNAL_PAGE_COOLDOWN", cooldown)) {
                return;
            }
            if (this.canBeUsed()) {
                this.type.handle(this.pagination);
            }
        };
    }

    private boolean canBeUsed() {
        return this.type == Type.PREVIOUS && !this.pagination.isFirstPage() || this.type == Type.NEXT && !this.pagination.isLastPage();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Type {
        PREVIOUS{

            @Override
            void handle(@NotNull IPagination<?, ?> pagination) {
                pagination.previousPage();
            }
        }
        ,
        NEXT{

            @Override
            void handle(@NotNull IPagination<?, ?> pagination) {
                pagination.nextPage();
            }
        };


        abstract void handle(@NotNull IPagination<?, ?> var1);
    }
}

