/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.items.buttons;

import java.util.function.Consumer;
import nl.odalitadevelopments.menus.OdalitaMenus;
import nl.odalitadevelopments.menus.contents.MenuContents;
import nl.odalitadevelopments.menus.items.PageUpdatableItem;
import nl.odalitadevelopments.menus.providers.providers.DefaultItemProvider;
import nl.odalitadevelopments.menus.scrollable.Scrollable;
import nl.odalitadevelopments.menus.utils.cooldown.Cooldown;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class ScrollItem
extends PageUpdatableItem {
    private final Direction direction;
    private final Scrollable scrollable;
    private final ItemStack itemStack;
    private final boolean showOnLastPage;

    @NotNull
    public static ScrollItem up(@NotNull Scrollable scrollable, @NotNull ItemStack itemStack, boolean showOnLastPage) {
        return new ScrollItem(Direction.UP, scrollable, itemStack, showOnLastPage);
    }

    @NotNull
    public static ScrollItem up(@NotNull Scrollable scrollable, @NotNull ItemStack itemStack) {
        return new ScrollItem(Direction.UP, scrollable, itemStack, false);
    }

    @NotNull
    public static ScrollItem up(@NotNull Scrollable scrollable, boolean showOnLastPage) {
        return new ScrollItem(Direction.UP, scrollable, showOnLastPage);
    }

    @NotNull
    public static ScrollItem up(@NotNull Scrollable scrollable) {
        return new ScrollItem(Direction.UP, scrollable, false);
    }

    @NotNull
    public static ScrollItem down(@NotNull Scrollable scrollable, @NotNull ItemStack itemStack, boolean showOnLastPage) {
        return new ScrollItem(Direction.DOWN, scrollable, itemStack, showOnLastPage);
    }

    @NotNull
    public static ScrollItem down(@NotNull Scrollable scrollable, @NotNull ItemStack itemStack) {
        return new ScrollItem(Direction.DOWN, scrollable, itemStack, false);
    }

    @NotNull
    public static ScrollItem down(@NotNull Scrollable scrollable, boolean showOnLastPage) {
        return new ScrollItem(Direction.DOWN, scrollable, showOnLastPage);
    }

    @NotNull
    public static ScrollItem down(@NotNull Scrollable scrollable) {
        return new ScrollItem(Direction.DOWN, scrollable, false);
    }

    @NotNull
    public static ScrollItem left(@NotNull Scrollable scrollable, @NotNull ItemStack itemStack, boolean showOnLastPage) {
        return new ScrollItem(Direction.LEFT, scrollable, itemStack, showOnLastPage);
    }

    @NotNull
    public static ScrollItem left(@NotNull Scrollable scrollable, @NotNull ItemStack itemStack) {
        return new ScrollItem(Direction.LEFT, scrollable, itemStack, false);
    }

    @NotNull
    public static ScrollItem left(@NotNull Scrollable scrollable, boolean showOnLastPage) {
        return new ScrollItem(Direction.LEFT, scrollable, showOnLastPage);
    }

    @NotNull
    public static ScrollItem left(@NotNull Scrollable scrollable) {
        return new ScrollItem(Direction.LEFT, scrollable, false);
    }

    @NotNull
    public static ScrollItem right(@NotNull Scrollable scrollable, @NotNull ItemStack itemStack, boolean showOnLastPage) {
        return new ScrollItem(Direction.RIGHT, scrollable, itemStack, showOnLastPage);
    }

    @NotNull
    public static ScrollItem right(@NotNull Scrollable scrollable, @NotNull ItemStack itemStack) {
        return new ScrollItem(Direction.RIGHT, scrollable, itemStack, false);
    }

    @NotNull
    public static ScrollItem right(@NotNull Scrollable scrollable, boolean showOnLastPage) {
        return new ScrollItem(Direction.RIGHT, scrollable, showOnLastPage);
    }

    @NotNull
    public static ScrollItem right(@NotNull Scrollable scrollable) {
        return new ScrollItem(Direction.RIGHT, scrollable, false);
    }

    private ScrollItem(Direction direction, Scrollable scrollable, ItemStack itemStack, boolean showOnLastPage) {
        this.direction = direction;
        this.scrollable = scrollable;
        this.itemStack = itemStack;
        this.showOnLastPage = showOnLastPage;
    }

    private ScrollItem(Direction direction, Scrollable scrollable, boolean showOnLastPage) {
        this(direction, scrollable, null, showOnLastPage);
    }

    @Override
    @NotNull
    protected ItemStack getItemStack(@NotNull OdalitaMenus instance, @NotNull MenuContents contents) {
        if (!this.showOnLastPage && this.isOnLastPageForDirection()) {
            return new ItemStack(Material.AIR);
        }
        if (this.itemStack == null) {
            DefaultItemProvider defaultItemProvider = instance.getProvidersContainer().getDefaultItemProvider();
            return switch (this.direction.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> defaultItemProvider.scrollUpItem(this.scrollable);
                case 1 -> defaultItemProvider.scrollDownItem(this.scrollable);
                case 2 -> defaultItemProvider.scrollLeftItem(this.scrollable);
                case 3 -> defaultItemProvider.scrollRightItem(this.scrollable);
            };
        }
        return this.itemStack;
    }

    @Override
    @NotNull
    public Consumer<InventoryClickEvent> onClick(@NotNull OdalitaMenus instance, @NotNull MenuContents contents) {
        return event -> {
            HumanEntity patt0$temp = event.getWhoClicked();
            if (!(patt0$temp instanceof Player)) {
                return;
            }
            Player player = (Player)patt0$temp;
            Cooldown cooldown = instance.getProvidersContainer().getCooldownProvider().scrollCooldown();
            if (cooldown != null && instance.getCooldownContainer().checkAndCreate(player.getUniqueId(), "INTERNAL_SCROLL_COOLDOWN", cooldown)) {
                return;
            }
            if (!this.isOnLastPageForDirection()) {
                this.direction.next(this.scrollable);
            }
        };
    }

    private boolean isOnLastPageForDirection() {
        return this.direction == Direction.UP && this.scrollable.isFirstVertical() || this.direction == Direction.DOWN && this.scrollable.isLastVertical() || this.direction == Direction.LEFT && this.scrollable.isFirstHorizontal() || this.direction == Direction.RIGHT && this.scrollable.isLastHorizontal();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Direction {
        UP{

            @Override
            void next(@NotNull Scrollable scrollable) {
                scrollable.previousVertical();
            }
        }
        ,
        DOWN{

            @Override
            void next(@NotNull Scrollable scrollable) {
                scrollable.nextVertical();
            }
        }
        ,
        LEFT{

            @Override
            void next(@NotNull Scrollable scrollable) {
                scrollable.previousHorizontal();
            }
        }
        ,
        RIGHT{

            @Override
            void next(@NotNull Scrollable scrollable) {
                scrollable.nextHorizontal();
            }
        };


        abstract void next(@NotNull Scrollable var1);
    }
}

