/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.iterators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nl.odalitadevelopments.menus.contents.MenuContents;
import nl.odalitadevelopments.menus.contents.pos.SlotPos;
import nl.odalitadevelopments.menus.iterators.MenuIteratorType;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractMenuIterator<T extends AbstractMenuIterator<T>> {
    private final T instance;
    protected final MenuContents contents;
    protected final MenuIteratorType type;
    protected final int startRow;
    protected final int startColumn;
    protected final List<Integer> availableSlotPositions = new ArrayList<Integer>();
    protected final Set<Integer> blacklist = new HashSet<Integer>();
    protected int index = 0;
    protected boolean override = false;

    protected AbstractMenuIterator(MenuContents contents, MenuIteratorType type, int startRow, int startColumn) {
        this.instance = this.self();
        this.contents = contents;
        this.type = type;
        this.startRow = startRow;
        this.startColumn = startColumn;
    }

    @NotNull
    protected abstract T self();

    public boolean hasNext() {
        this.init(this.type);
        return this.availableSlotPositions.size() > this.index + 1;
    }

    public int getSlot() {
        this.init(this.type);
        return this.availableSlotPositions.get(this.index);
    }

    public int next() {
        this.init(this.type);
        return this.availableSlotPositions.get(this.index++);
    }

    public int previous() {
        this.init(this.type);
        return this.availableSlotPositions.get(--this.index);
    }

    @NotNull
    public T reset() {
        this.index = 0;
        return this.instance;
    }

    @NotNull
    public T blacklist(int slot) {
        this.blacklist.add(slot);
        return this.instance;
    }

    @NotNull
    public T blacklist(int ... slots) {
        Arrays.stream(slots).forEach(this.blacklist::add);
        return this.instance;
    }

    @NotNull
    public T override(boolean override) {
        this.override = override;
        return this.instance;
    }

    @NotNull
    public SlotPos getStartSlotPos() {
        return this.getSlotPos(this.startRow, this.startColumn);
    }

    @NotNull
    protected Inventory getInventory() {
        return this.contents.menuSession().getInventory();
    }

    @NotNull
    protected SlotPos getSlotPos(int row, int column) {
        return SlotPos.of(this.contents.maxRows(), this.contents.maxColumns(), row, column);
    }

    @NotNull
    protected SlotPos getSlotPos(int slot) {
        return SlotPos.of(this.contents.maxRows(), this.contents.maxColumns(), slot);
    }

    @NotNull
    protected SlotPos getCorrectSlotPos(int slot) {
        return this.getSlotPos(slot).convertFromFrame(this.contents.menuSession().getRows(), this.contents.menuSession().getColumns(), this.contents.menuFrameData());
    }

    protected void init(@NotNull MenuIteratorType menuIteratorType) {
        if (!this.availableSlotPositions.isEmpty()) {
            return;
        }
        switch (menuIteratorType) {
            case HORIZONTAL: {
                this.horizontalInitialization();
                break;
            }
            case VERTICAL: {
                this.verticalInitialization();
            }
        }
    }

    private void horizontalInitialization() {
        int slotStart;
        int inventorySize = this.contents.maxRows() * this.contents.maxColumns();
        Inventory inventory = this.getInventory();
        for (int slot = slotStart = this.getStartSlotPos().getSlot(); slot < inventorySize; ++slot) {
            if (this.blacklist.contains(slot)) continue;
            int inventorySlot = this.getCorrectSlotPos(slot).getSlot();
            ItemStack item = inventory.getItem(inventorySlot);
            if (!this.override && item != null && item.getType() != Material.AIR) continue;
            this.availableSlotPositions.add(slot);
        }
    }

    private void verticalInitialization() {
        Inventory inventory = this.getInventory();
        for (int column = this.startColumn; column < this.contents.maxColumns(); ++column) {
            for (int row = this.startRow; row < this.contents.maxRows(); ++row) {
                int currentSlot = this.getSlotPos(row, column).getSlot();
                if (this.blacklist.contains(currentSlot)) continue;
                currentSlot = this.getCorrectSlotPos(currentSlot).getSlot();
                ItemStack item = inventory.getItem(currentSlot);
                if (!this.override && item != null && item.getType() != Material.AIR) continue;
                this.availableSlotPositions.add(currentSlot);
            }
        }
    }
}

