/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.iterators;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import nl.odalitadevelopments.menus.contents.MenuContents;
import nl.odalitadevelopments.menus.items.MenuItem;
import nl.odalitadevelopments.menus.iterators.AbstractMenuIterator;
import nl.odalitadevelopments.menus.iterators.MenuIteratorType;
import nl.odalitadevelopments.menus.pagination.ObjectPagination;
import nl.odalitadevelopments.menus.utils.BukkitThreadHelper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class MenuObjectIterator<T>
extends AbstractMenuIterator<MenuObjectIterator<T>> {
    private final List<T> allObjects;
    private final Function<T, MenuItem> menuItemCreatorFunction;
    private boolean batch = false;
    private final Map<String, Predicate<T>> filters = new HashMap<String, Predicate<T>>();
    private final Map<Integer, Comparator<T>> sorters = new TreeMap<Integer, Comparator<T>>();
    private volatile List<T> filteredObjects;
    private Consumer<MenuContents> emptyFilteredItemsConsumer = null;
    private ObjectPagination<T> pagination = null;
    private volatile boolean isApplying = false;

    public MenuObjectIterator(MenuContents contents, MenuIteratorType type, int startRow, int startColumn, Function<T, MenuItem> menuItemCreatorFunction) {
        super(contents, type, startRow, startColumn);
        this.allObjects = Lists.newCopyOnWriteArrayList();
        this.menuItemCreatorFunction = menuItemCreatorFunction;
    }

    @Override
    @NotNull
    protected MenuObjectIterator<T> self() {
        return this;
    }

    @NotNull
    public MenuObjectIterator<T> emptyFilteredItemsAction(@NotNull Consumer<MenuContents> consumer) {
        this.emptyFilteredItemsConsumer = consumer;
        return this;
    }

    @NotNull
    public MenuObjectIterator<T> emptyFilteredItemsAction(@NotNull Runnable runnable) {
        this.emptyFilteredItemsConsumer = $ -> runnable.run();
        return this;
    }

    @NotNull
    public MenuObjectIterator<T> filter(@NotNull String id, @NotNull @NotNull Predicate<@NotNull T> predicate) {
        this.filters.put(id, predicate);
        return this;
    }

    @NotNull
    public MenuObjectIterator<T> sorter(int priority, @NotNull @NotNull Comparator<@NotNull T> comparator) {
        this.sorters.put(priority, comparator);
        return this;
    }

    @NotNull
    public MenuObjectIterator<T> removeFilter(@NotNull String id) {
        this.filters.remove(id);
        return this;
    }

    @NotNull
    public MenuObjectIterator<T> removeSorter(int priority) {
        this.sorters.remove(priority);
        return this;
    }

    public void createBatch() {
        this.batch = true;
    }

    public void endBatch() {
        this.batch = false;
        this.apply();
    }

    public void add(@NotNull T value) {
        this.allObjects.add(value);
        if (!this.batch) {
            this.apply();
        }
    }

    public boolean apply() {
        if (this.isApplying) {
            return false;
        }
        super.reset();
        BukkitThreadHelper.runCondition(this.pagination != null && this.pagination.isAsync(), this.contents.menuSession().getInstance().getJavaPlugin(), () -> {
            this.isApplying = true;
            this.filteredObjects = new ArrayList<T>(this.allObjects);
            for (Predicate<T> predicate : this.filters.values()) {
                this.filteredObjects.removeIf(predicate.negate());
            }
            Comparator<T> comparator = null;
            for (Comparator<T> sorter : this.sorters.values()) {
                if (comparator == null) {
                    comparator = sorter;
                    continue;
                }
                comparator = comparator.thenComparing(sorter);
            }
            if (comparator != null) {
                this.filteredObjects.sort(comparator);
            }
            if (this.pagination == null) {
                for (T value : this.allObjects) {
                    MenuItem item;
                    if (!super.hasNext() || (item = this.menuItemCreatorFunction.apply(value)) == null) continue;
                    int slot = super.next();
                    this.contents.set(slot, item);
                }
            } else {
                int n = !this.filters.isEmpty() ? 0 : this.pagination.currentPage();
                this.pagination.open(n);
            }
            if (this.filteredObjects.isEmpty() && this.emptyFilteredItemsConsumer != null) {
                this.emptyFilteredItemsConsumer.accept(this.contents);
            }
            this.isApplying = false;
        });
        return true;
    }

    @ApiStatus.Internal
    @NotNull
    public List<T> getObjects() {
        return this.filteredObjects == null ? List.of() : List.copyOf(this.filteredObjects);
    }

    @ApiStatus.Internal
    public MenuItem createMenuItem(@NotNull T value) {
        return this.menuItemCreatorFunction.apply(value);
    }

    @ApiStatus.Internal
    public void pagination(@NotNull ObjectPagination<T> pagination) {
        if (this.pagination == null) {
            this.pagination = pagination;
        }
    }
}

