/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.listeners;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import nl.odalitadevelopments.menus.OdalitaMenus;
import nl.odalitadevelopments.menus.contents.action.MenuCloseResult;
import nl.odalitadevelopments.menus.contents.placeableitem.PlaceableItemClickAction;
import nl.odalitadevelopments.menus.contents.placeableitem.PlaceableItemDragAction;
import nl.odalitadevelopments.menus.contents.placeableitem.PlaceableItemShiftClickAction;
import nl.odalitadevelopments.menus.contents.placeableitem.PlaceableItemsCloseAction;
import nl.odalitadevelopments.menus.contents.pos.SlotPos;
import nl.odalitadevelopments.menus.items.MenuItem;
import nl.odalitadevelopments.menus.listeners.OdalitaEventListener;
import nl.odalitadevelopments.menus.menu.MenuProcessor;
import nl.odalitadevelopments.menus.menu.MenuSession;
import nl.odalitadevelopments.menus.menu.type.SupportedMenuType;
import nl.odalitadevelopments.menus.nms.OdalitaMenusNMS;
import nl.odalitadevelopments.menus.utils.BukkitThreadHelper;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public final class InventoryListener
implements Listener {
    private final OdalitaMenus instance;
    private final MenuProcessor menuProcessor;

    @EventHandler(priority=EventPriority.LOW)
    public void onInventoryClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        MenuSession menuSession = this.menuProcessor.getOpenMenuSession(player);
        if (menuSession == null) {
            return;
        }
        if (event.getAction() == InventoryAction.HOTBAR_SWAP || event.getAction() == InventoryAction.HOTBAR_MOVE_AND_READD || event.getClick() == ClickType.DOUBLE_CLICK) {
            event.setCancelled(true);
            return;
        }
        ItemStack currentItem = event.getCurrentItem();
        SupportedMenuType menuType = menuSession.getMenuType();
        Inventory clickedInventory = event.getClickedInventory();
        Inventory topInventory = OdalitaMenusNMS.getInstance().getTopInventory((InventoryEvent)event);
        if (topInventory.equals((Object)menuSession.getInventory()) && event.getRawSlot() >= 0) {
            boolean clickedTopInventory = topInventory.equals((Object)clickedInventory);
            if (!clickedTopInventory && currentItem != null && menuSession.getCache().getPlayerInventoryClickAction() != null) {
                event.setCancelled(true);
                menuSession.getCache().getPlayerInventoryClickAction().accept(event);
                if (event.isCancelled()) {
                    return;
                }
            }
            if (event.getClick().isShiftClick() && clickedTopInventory && !menuSession.getCache().isAllowPlaceableItemShiftClick()) {
                event.setCancelled(true);
                return;
            }
            List<Integer> placeableItemsSlots = menuSession.getCache().getPlaceableItems();
            if (event.getClick().isShiftClick() && !clickedTopInventory) {
                Object item;
                int slot;
                event.setCancelled(true);
                if (currentItem == null || placeableItemsSlots.isEmpty() || !menuSession.getCache().isAllowPlaceableItemShiftClick()) {
                    return;
                }
                ItemStack currentItemClone = currentItem.clone();
                HashMap<Integer, Object> slotsModified = new HashMap<Integer, Object>();
                NavigableMap<Integer, ItemStack> placeableItems = this.getPlaceableItems(menuSession.getInventory(), placeableItemsSlots);
                for (Map.Entry entry : placeableItems.entrySet()) {
                    slot = (Integer)entry.getKey();
                    item = (ItemStack)entry.getValue();
                    if (item == null || item.getType().isAir() || !item.isSimilar(currentItem)) continue;
                    int maxStackSize = item.getMaxStackSize();
                    int amount = item.getAmount();
                    int amountToAdd = currentItemClone.getAmount();
                    item = item.clone();
                    if (amount + amountToAdd > maxStackSize) {
                        int amountLeft = maxStackSize - amount;
                        item.setAmount(maxStackSize);
                        currentItemClone.setAmount(amountToAdd - amountLeft);
                        slotsModified.put(slot, item);
                        continue;
                    }
                    item.setAmount(amount + amountToAdd);
                    currentItemClone = null;
                    slotsModified.put(slot, item);
                    break;
                }
                if (currentItemClone != null) {
                    for (Map.Entry entry : placeableItems.entrySet()) {
                        slot = (Integer)entry.getKey();
                        item = (ItemStack)entry.getValue();
                        if (item != null && !item.getType().isAir()) continue;
                        slotsModified.put(slot, currentItemClone);
                        currentItemClone = null;
                        break;
                    }
                }
                if (!slotsModified.isEmpty()) {
                    PlaceableItemShiftClickAction action = menuSession.getCache().getPlaceableItemShiftClickAction();
                    boolean shouldPlace = true;
                    if (action != null) {
                        ArrayList<SlotPos> slotPosses = new ArrayList<SlotPos>();
                        for (Integer slot2 : slotsModified.keySet()) {
                            slotPosses.add(SlotPos.of(menuType.maxRows(), menuType.maxColumns(), slot2));
                        }
                        shouldPlace = action.shouldPlace(slotPosses, currentItem, event);
                    }
                    if (shouldPlace) {
                        for (Map.Entry entry : slotsModified.entrySet()) {
                            topInventory.setItem(((Integer)entry.getKey()).intValue(), (ItemStack)entry.getValue());
                            event.setCurrentItem(currentItemClone);
                        }
                    }
                }
                return;
            }
            if (!placeableItemsSlots.isEmpty() && !clickedTopInventory) {
                return;
            }
            if (placeableItemsSlots.contains(event.getRawSlot())) {
                PlaceableItemClickAction action = menuSession.getCache().getPlaceableItemClickAction();
                if (action != null && !action.shouldPlace(SlotPos.of(menuType.maxRows(), menuType.maxColumns(), event.getRawSlot()), event)) {
                    event.setCancelled(true);
                }
                return;
            }
            event.setCancelled(true);
            MenuItem menuItem = menuSession.getContent(SlotPos.of(menuType.maxRows(), menuType.maxColumns(), event.getRawSlot()));
            if (menuItem != null) {
                menuItem.onClick(this.instance, menuSession.getMenuContents()).accept(event);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onInventoryDrag(InventoryDragEvent event) {
        Player player = (Player)event.getWhoClicked();
        MenuSession menuSession = this.menuProcessor.getOpenMenuSession(player);
        if (menuSession == null) {
            return;
        }
        if (!menuSession.getCache().isAllowPlaceableItemDrag()) {
            event.setCancelled(true);
            return;
        }
        SupportedMenuType menuType = menuSession.getMenuType();
        List<Integer> placeableItems = menuSession.getCache().getPlaceableItems();
        Inventory topInventory = OdalitaMenusNMS.getInstance().getTopInventory((InventoryEvent)event);
        if (topInventory.equals((Object)menuSession.getInventory())) {
            Set inventorySlots = event.getRawSlots();
            boolean fitsInMenu = event.getRawSlots().stream().allMatch(integer -> integer > menuSession.getInventory().getSize() - 1);
            if (!placeableItems.isEmpty() && fitsInMenu) {
                return;
            }
            boolean matchAllSlots = new HashSet<Integer>(placeableItems).containsAll(inventorySlots);
            if (!matchAllSlots) {
                event.setCancelled(true);
                return;
            }
            ArrayList<SlotPos> slotPosses = new ArrayList<SlotPos>();
            for (Integer slot : inventorySlots) {
                slotPosses.add(SlotPos.of(menuType.maxRows(), menuType.maxColumns(), slot));
            }
            PlaceableItemDragAction action = menuSession.getCache().getPlaceableItemDragAction();
            if (action != null && !action.shouldPlace(slotPosses, event)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onInventoryClose(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        MenuSession menuSession = this.menuProcessor.getOpenMenuSession(player);
        if (menuSession == null) {
            return;
        }
        Inventory inventory = event.getInventory();
        if (menuSession.getInventory().equals((Object)inventory)) {
            Supplier<MenuCloseResult> closeActionAfter;
            Supplier<MenuCloseResult> closeActionBefore = menuSession.getCache().getCloseActionBefore();
            if (closeActionBefore != null && closeActionBefore.get() == MenuCloseResult.KEEP_OPEN) {
                Bukkit.getScheduler().runTask((Plugin)this.instance.getJavaPlugin(), () -> player.openInventory(inventory));
                return;
            }
            for (OdalitaEventListener eventListener : menuSession.getCache().getEventListeners()) {
                eventListener.unregister();
            }
            PlaceableItemsCloseAction action = menuSession.getCache().getPlaceableItemsCloseAction();
            if (action != null && action.equals((Object)PlaceableItemsCloseAction.RETURN)) {
                List<Integer> placeableItemsSlots = menuSession.getCache().getPlaceableItems();
                NavigableMap<Integer, ItemStack> placeableItems = this.getPlaceableItems(inventory, placeableItemsSlots);
                for (ItemStack item : placeableItems.values()) {
                    HashMap rest;
                    if (item == null || item.getType().isAir() || (rest = player.getInventory().addItem(new ItemStack[]{item})).isEmpty()) continue;
                    rest.values().forEach(itemStack -> player.getWorld().dropItem(player.getLocation(), itemStack));
                }
            }
            if ((closeActionAfter = menuSession.getCache().getCloseActionAfter()) != null && closeActionAfter.get() == MenuCloseResult.KEEP_OPEN) {
                Bukkit.getScheduler().runTask((Plugin)this.instance.getJavaPlugin(), menuSession::reopen);
            }
            menuSession.setClosed(true);
            this.menuProcessor.getOpenMenus().remove(player);
            BukkitThreadHelper.runAsync(this.instance.getJavaPlugin(), () -> ((Player)player).updateInventory());
        }
    }

    private NavigableMap<Integer, ItemStack> getPlaceableItems(Inventory inventory, List<Integer> placeableItemSlots) {
        TreeMap<Integer, ItemStack> placeableItems = new TreeMap<Integer, ItemStack>();
        for (Integer placeableItemSlot : placeableItemSlots) {
            ItemStack item = inventory.getItem(placeableItemSlot.intValue());
            placeableItems.put(placeableItemSlot, item);
        }
        return placeableItems;
    }

    public InventoryListener(OdalitaMenus instance, MenuProcessor menuProcessor) {
        this.instance = instance;
        this.menuProcessor = menuProcessor;
    }
}

