/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.listeners;

import java.util.List;
import nl.odalitadevelopments.menus.OdalitaMenus;
import nl.odalitadevelopments.menus.contents.action.PlayerInventoryItemMetaChanger;
import nl.odalitadevelopments.menus.menu.MenuProcessor;
import nl.odalitadevelopments.menus.menu.MenuSession;
import nl.odalitadevelopments.menus.providers.providers.PacketListenerProvider;
import nl.odalitadevelopments.menus.utils.packet.OdalitaSetContentsPacket;
import nl.odalitadevelopments.menus.utils.packet.OdalitaSetSlotPacket;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class InventoryPacketListener {
    private final OdalitaMenus instance;
    private final MenuProcessor menuProcessor;

    public InventoryPacketListener(OdalitaMenus instance, MenuProcessor menuProcessor) {
        this.instance = instance;
        this.menuProcessor = menuProcessor;
        this.listenSetSlot();
        this.listenWindowItems();
    }

    private void listenSetSlot() {
        this.instance.getProvidersContainer().getPacketListenerProvider().listenClientbound(PacketListenerProvider.ClientboundPacketType.SET_SLOT, (player, odalitaMenuPacket) -> {
            int topInventorySize;
            if (!(odalitaMenuPacket instanceof OdalitaSetSlotPacket)) {
                return;
            }
            OdalitaSetSlotPacket packet = (OdalitaSetSlotPacket)odalitaMenuPacket;
            MenuSession menuSession = this.menuProcessor.getOpenMenuSession((Player)player);
            if (menuSession == null) {
                return;
            }
            PlayerInventoryItemMetaChanger itemMetaChanger = menuSession.getCache().getItemMetaChanger();
            if (itemMetaChanger == null) {
                return;
            }
            ItemStack itemStack = packet.item();
            if (this.isEmpty(itemStack)) {
                return;
            }
            int slot = packet.slot();
            if (slot < (topInventorySize = menuSession.getInventory().getSize())) {
                return;
            }
            itemMetaChanger.apply(this.convertSlot(topInventorySize, slot), itemStack);
        });
    }

    private void listenWindowItems() {
        this.instance.getProvidersContainer().getPacketListenerProvider().listenClientbound(PacketListenerProvider.ClientboundPacketType.SET_CONTENTS, (player, odalitaMenuPacket) -> {
            int topInventorySize;
            if (!(odalitaMenuPacket instanceof OdalitaSetContentsPacket)) {
                return;
            }
            OdalitaSetContentsPacket packet = (OdalitaSetContentsPacket)odalitaMenuPacket;
            MenuSession menuSession = this.menuProcessor.getOpenMenuSession((Player)player);
            if (menuSession == null) {
                return;
            }
            PlayerInventoryItemMetaChanger itemMetaChanger = menuSession.getCache().getItemMetaChanger();
            if (itemMetaChanger == null) {
                return;
            }
            List<@NotNull ItemStack> items = packet.items();
            for (int i = topInventorySize = menuSession.getInventory().getSize(); i < items.size(); ++i) {
                ItemStack itemStack = items.get(i);
                if (this.isEmpty(itemStack)) continue;
                itemMetaChanger.apply(this.convertSlot(topInventorySize, i), itemStack);
            }
        });
    }

    private boolean isEmpty(ItemStack itemStack) {
        return itemStack == null || itemStack.getType() == Material.AIR || itemStack.getAmount() <= 0;
    }

    private int convertSlot(int topSize, int rawSlot) {
        if (rawSlot < topSize) {
            return rawSlot;
        }
        int slot = rawSlot - topSize;
        slot = slot >= 27 ? (slot -= 27) : (slot += 9);
        return slot;
    }
}

