/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.menu;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import nl.odalitadevelopments.menus.menu.MenuProcessor;
import nl.odalitadevelopments.menus.menu.providers.frame.MenuFrameProvider;
import nl.odalitadevelopments.menus.menu.providers.frame.MenuFrameProviderLoader;
import org.jetbrains.annotations.NotNull;

public final class MenuFrameProcessor {
    private final MenuProcessor menuProcessor;
    private final Map<Class<? extends MenuFrameProvider>, MenuFrameProviderLoader<?>> frameProviderLoaders = new ConcurrentHashMap();
    private final Map<Class<? extends MenuFrameProvider>, MenuFrameProviderLoader<?>> frameProviderLoaderCache = new HashMap();

    MenuFrameProcessor(MenuProcessor menuProcessor) {
        this.menuProcessor = menuProcessor;
    }

    public <P extends MenuFrameProvider> void registerFrameProviderLoader(@NotNull Class<P> providerClass, @NotNull MenuFrameProviderLoader<P> loader) {
        if (!providerClass.isInterface()) {
            throw new IllegalArgumentException("Frame menu providers must be an interface");
        }
        MenuFrameProviderLoader<P> previous = this.frameProviderLoaders.putIfAbsent(providerClass, loader);
        if (previous != null) {
            throw new IllegalStateException("Frame provider loader for '" + providerClass.getName() + "' already registered");
        }
    }

    public <P extends MenuFrameProvider> boolean isFrameProviderLoaderRegistered(@NotNull Class<P> providerClass) {
        return this.frameProviderLoaders.containsKey(providerClass);
    }

    @NotNull
    public <P extends MenuFrameProvider> MenuFrameProviderLoader<P> getFrameProviderLoader(@NotNull P menuProvider) {
        MenuFrameProviderLoader<Object> providerLoader = this.frameProviderLoaderCache.get(menuProvider.getClass());
        if (providerLoader == null) {
            Class<?> providerLoaderClass = this.menuProcessor.findProviderLoader(menuProvider.getClass(), MenuFrameProvider.class);
            providerLoader = this.frameProviderLoaders.get(providerLoaderClass);
            if (providerLoader == null) {
                providerLoader = MenuFrameProviderLoader.defaultLoader();
            }
            this.frameProviderLoaderCache.put(menuProvider.getClass(), providerLoader);
        }
        return providerLoader;
    }

    public Map<Class<? extends MenuFrameProvider>, MenuFrameProviderLoader<?>> getFrameProviderLoaders() {
        return this.frameProviderLoaders;
    }
}

