/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.menu;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import nl.odalitadevelopments.menus.items.ItemProcessor;
import nl.odalitadevelopments.menus.menu.MenuInitializer;
import nl.odalitadevelopments.menus.menu.MenuOpenerBuilder;
import nl.odalitadevelopments.menus.menu.MenuProcessor;
import nl.odalitadevelopments.menus.menu.providers.MenuProvider;
import nl.odalitadevelopments.menus.menu.providers.MenuProviderLoader;
import nl.odalitadevelopments.menus.menu.type.SupportedMenuTypes;
import nl.odalitadevelopments.menus.utils.BukkitThreadHelper;
import nl.odalitadevelopments.menus.utils.Pair;
import nl.odalitadevelopments.menus.utils.Triple;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

final class MenuOpenerBuilderImpl<P extends MenuProvider>
implements MenuOpenerBuilder {
    private final MenuProcessor menuProcessor;
    private final ItemProcessor itemProcessor;
    private final SupportedMenuTypes supportedMenuTypes;
    private final P provider;
    private final Player player;
    private final MenuProviderLoader<P> providerLoader;
    private final Map<String, Integer> paginationPages = new HashMap<String, Integer>();
    private final Map<String, Pair<Integer, Integer>> scrollableAxes = new HashMap<String, Pair<Integer, Integer>>();

    MenuOpenerBuilderImpl(MenuProcessor menuProcessor, ItemProcessor itemProcessor, SupportedMenuTypes supportedMenuTypes, P provider, Player player, MenuProviderLoader<P> providerLoader) {
        this.menuProcessor = menuProcessor;
        this.itemProcessor = itemProcessor;
        this.supportedMenuTypes = supportedMenuTypes;
        this.provider = provider;
        this.player = player;
        this.providerLoader = providerLoader;
    }

    @Override
    @NotNull
    public MenuOpenerBuilder pagination(@NotNull String id, int page) {
        this.paginationPages.put(id, page);
        return this;
    }

    @Override
    @NotNull
    public MenuOpenerBuilder paginationPages(@NotNull @NotNull Collection<@NotNull Pair<@NotNull String, @NotNull Integer>> paginationPages) {
        for (Pair<String, Integer> page : paginationPages) {
            this.paginationPages.put(page.getKey(), page.getValue());
        }
        return this;
    }

    @Override
    @NotNull
    public MenuOpenerBuilder paginationPages(@NotNull @NotNull Supplier<@NotNull Collection<@NotNull Pair<@NotNull String, @NotNull Integer>>> paginationPages) {
        return this.paginationPages(paginationPages.get());
    }

    @Override
    @NotNull
    public MenuOpenerBuilder scrollable(@NotNull String id, int xAxis, int yAxis) {
        this.scrollableAxes.put(id, Pair.of(xAxis, yAxis));
        return this;
    }

    @Override
    @NotNull
    public MenuOpenerBuilder scrollableAxes(@NotNull @NotNull Collection<@NotNull Triple<@NotNull String, @NotNull Integer, Integer>> scrollableAxes) {
        for (Triple<String, Integer, Integer> axis : scrollableAxes) {
            this.scrollableAxes.put(axis.getFirst(), Pair.of(axis.getSecond(), axis.getThird()));
        }
        return this;
    }

    @Override
    @NotNull
    public MenuOpenerBuilder scrollableAxes(@NotNull @NotNull Supplier<@NotNull Collection<@NotNull Triple<@NotNull String, @NotNull Integer, Integer>>> scrollableAxes) {
        return this.scrollableAxes(scrollableAxes.get());
    }

    @Override
    public void open() {
        BukkitThreadHelper.runSync(this.menuProcessor.getInstance().getJavaPlugin(), () -> new MenuInitializer(this.menuProcessor, this.itemProcessor, this.supportedMenuTypes, this).initializeMenu());
    }

    P getProvider() {
        return this.provider;
    }

    Player getPlayer() {
        return this.player;
    }

    MenuProviderLoader<P> getProviderLoader() {
        return this.providerLoader;
    }

    Map<String, Integer> getPaginationPages() {
        return this.paginationPages;
    }

    Map<String, Pair<Integer, Integer>> getScrollableAxes() {
        return this.scrollableAxes;
    }
}

