/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.menu;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import nl.odalitadevelopments.menus.OdalitaMenus;
import nl.odalitadevelopments.menus.items.ItemProcessor;
import nl.odalitadevelopments.menus.menu.MenuFrameProcessor;
import nl.odalitadevelopments.menus.menu.MenuOpenerBuilder;
import nl.odalitadevelopments.menus.menu.MenuOpenerBuilderImpl;
import nl.odalitadevelopments.menus.menu.MenuSession;
import nl.odalitadevelopments.menus.menu.providers.MenuProvider;
import nl.odalitadevelopments.menus.menu.providers.MenuProviderLoader;
import nl.odalitadevelopments.menus.menu.type.SupportedMenuTypes;
import nl.odalitadevelopments.menus.nms.utils.OdalitaLogger;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MenuProcessor {
    private final OdalitaMenus instance;
    private final ItemProcessor itemProcessor;
    private final SupportedMenuTypes supportedMenuTypes;
    private final MenuFrameProcessor menuFrameProcessor;
    private final Map<Class<? extends MenuProvider>, MenuProviderLoader<?>> providerLoaders = new ConcurrentHashMap();
    private final Map<Class<? extends MenuProvider>, MenuProviderLoader<?>> providerLoaderCache = new HashMap();
    private final Map<Player, MenuSession> openMenus = new ConcurrentHashMap<Player, MenuSession>();

    public MenuProcessor(OdalitaMenus instance, ItemProcessor itemProcessor, SupportedMenuTypes supportedMenuTypes) {
        this.instance = instance;
        this.itemProcessor = itemProcessor;
        this.supportedMenuTypes = supportedMenuTypes;
        this.menuFrameProcessor = new MenuFrameProcessor(this);
    }

    public <P extends MenuProvider> void registerProviderLoader(@NotNull Class<P> providerClass, @NotNull MenuProviderLoader<P> loader) {
        if (!providerClass.isInterface()) {
            throw new IllegalArgumentException("Menu providers must be an interface");
        }
        MenuProviderLoader<P> previous = this.providerLoaders.putIfAbsent(providerClass, loader);
        if (previous != null) {
            throw new IllegalStateException("Provider loader for '" + providerClass.getName() + "' already registered");
        }
    }

    public <P extends MenuProvider> boolean isProviderLoaderRegistered(@NotNull Class<P> providerClass) {
        return this.providerLoaders.containsKey(providerClass);
    }

    public void openMenu(@NotNull MenuProvider menuProvider, @NotNull Player player) {
        this.openMenuBuilder(menuProvider, player).open();
    }

    @NotNull
    public <P extends MenuProvider> MenuOpenerBuilder openMenuBuilder(@NotNull P menuProvider, @NotNull Player player) {
        MenuProviderLoader<Object> providerLoader = this.providerLoaderCache.get(menuProvider.getClass());
        if (providerLoader == null) {
            Class<?> providerLoaderClass = this.findProviderLoader(menuProvider.getClass(), MenuProvider.class);
            providerLoader = this.providerLoaders.get(providerLoaderClass);
            if (providerLoader == null) {
                providerLoader = MenuProviderLoader.defaultLoader();
            }
            this.providerLoaderCache.put(menuProvider.getClass(), providerLoader);
        }
        return new MenuOpenerBuilderImpl<P>(this, this.itemProcessor, this.supportedMenuTypes, menuProvider, player, providerLoader);
    }

    @NotNull
    public @NotNull Collection<@NotNull Player> getPlayersWithOpenMenu() {
        return this.openMenus.keySet();
    }

    @NotNull
    public @NotNull Collection<@NotNull Player> getPlayersWithOpenMenu(@NotNull String id) {
        if (id.isEmpty() || id.isBlank()) {
            return new HashSet<Player>();
        }
        HashSet<Player> players = new HashSet<Player>();
        for (Map.Entry<Player, MenuSession> entry : this.openMenus.entrySet()) {
            String menuId = entry.getValue().getId();
            if (menuId == null || !menuId.equals(id)) continue;
            players.add(entry.getKey());
        }
        return players;
    }

    @NotNull
    public @NotNull Collection<@NotNull MenuSession> getOpenMenuSessions() {
        return this.openMenus.values();
    }

    @NotNull
    public @NotNull Collection<@NotNull MenuSession> getOpenMenuSessions(@NotNull String id) {
        if (id.isEmpty() || id.isBlank()) {
            return new HashSet<MenuSession>();
        }
        HashSet<MenuSession> sessions = new HashSet<MenuSession>();
        for (Map.Entry<Player, MenuSession> entry : this.openMenus.entrySet()) {
            String menuId = entry.getValue().getId();
            if (menuId == null || !menuId.equals(id)) continue;
            sessions.add(entry.getValue());
        }
        return sessions;
    }

    @Nullable
    public MenuSession getOpenMenuSession(@NotNull Player player) {
        return this.openMenus.get(player);
    }

    Class<?> findProviderLoader(Class<?> menuProviderClass, Class<?> providerClass) {
        try {
            Class<?>[] interfaces;
            for (Class<?> menuInterface : interfaces = menuProviderClass.getInterfaces()) {
                if (!providerClass.isAssignableFrom(menuInterface)) continue;
                return menuInterface;
            }
        }
        catch (Exception exception) {
            OdalitaLogger.error(exception);
        }
        return null;
    }

    OdalitaMenus getInstance() {
        return this.instance;
    }

    ItemProcessor getItemProcessor() {
        return this.itemProcessor;
    }

    SupportedMenuTypes getSupportedMenuTypes() {
        return this.supportedMenuTypes;
    }

    Map<Class<? extends MenuProvider>, MenuProviderLoader<?>> getProviderLoaderCache() {
        return this.providerLoaderCache;
    }

    public MenuFrameProcessor getMenuFrameProcessor() {
        return this.menuFrameProcessor;
    }

    public Map<Class<? extends MenuProvider>, MenuProviderLoader<?>> getProviderLoaders() {
        return this.providerLoaders;
    }

    public Map<Player, MenuSession> getOpenMenus() {
        return this.openMenus;
    }
}

