/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.menu;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import nl.odalitadevelopments.menus.OdalitaMenus;
import nl.odalitadevelopments.menus.contents.MenuContents;
import nl.odalitadevelopments.menus.contents.action.MenuProperty;
import nl.odalitadevelopments.menus.contents.pos.SlotPos;
import nl.odalitadevelopments.menus.items.MenuItem;
import nl.odalitadevelopments.menus.menu.MenuOpenerBuilderImpl;
import nl.odalitadevelopments.menus.menu.cache.MenuSessionCache;
import nl.odalitadevelopments.menus.menu.type.InventoryCreation;
import nl.odalitadevelopments.menus.menu.type.MenuType;
import nl.odalitadevelopments.menus.menu.type.SupportedMenuType;
import nl.odalitadevelopments.menus.nms.OdalitaMenusNMS;
import nl.odalitadevelopments.menus.nms.utils.OdalitaLogger;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MenuSession {
    private final OdalitaMenus instance;
    private final MenuOpenerBuilderImpl<?> builder;
    private final Player player;
    private String id;
    private SupportedMenuType menuType;
    private InventoryCreation inventoryData;
    private String title;
    private final MenuContents menuContents;
    public volatile MenuItem[][] contents;
    private volatile boolean hasUpdatableItems = false;
    private String globalCacheKey;
    private final MenuSessionCache cache;
    private volatile boolean initialized = false;
    private volatile boolean opened = false;
    private volatile boolean closed = false;
    private final Collection<Runnable> openActions = Sets.newConcurrentHashSet();

    MenuSession(OdalitaMenus instance, MenuOpenerBuilderImpl<?> builder, Player player, String id, SupportedMenuType menuType, InventoryCreation inventoryData, String title, String globalCacheKey) {
        this.instance = instance;
        this.builder = builder;
        this.player = player;
        this.id = id;
        this.menuType = menuType;
        this.inventoryData = inventoryData;
        this.contents = new MenuItem[this.getRows()][this.getColumns()];
        this.title = title;
        this.globalCacheKey = globalCacheKey;
        this.cache = new MenuSessionCache(this);
        this.menuContents = MenuContents.create(this);
    }

    void initialized() {
        this.initialized = true;
    }

    void opened() {
        this.opened = true;
        for (Runnable action : this.openActions) {
            action.run();
        }
        this.openActions.clear();
    }

    public void setId(@NotNull String id) {
        if (this.id != null && this.id.equals(id)) {
            return;
        }
        this.id = id;
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventoryData.bukkitInventory();
    }

    public synchronized void setTitle(@NotNull String title) {
        if (this.title.equals(title)) {
            return;
        }
        String oldTitle = this.title;
        this.title = this.instance.getProvidersContainer().getColorProvider().handle(title);
        try {
            OdalitaMenusNMS.getInstance().changeInventoryTitle(this.getInventory(), this.title);
        }
        catch (Exception exception) {
            OdalitaLogger.error(exception);
            this.title = oldTitle;
        }
    }

    public void setMenuType(@NotNull MenuType menuType) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Cannot change menu type asynchronous!");
        }
        if (this.menuType.type().equals((Object)menuType)) {
            return;
        }
        if (this.opened) {
            throw new IllegalStateException("Cannot change menu type while menu is opened!");
        }
        this.menuType = this.instance.getSupportedMenuTypes().getSupportedMenuType(menuType);
        MenuItem[][] newContents = new MenuItem[this.getRows()][this.getColumns()];
        for (int i = 0; i < this.contents.length && i < newContents.length; ++i) {
            System.arraycopy(this.contents[i], 0, newContents[i], 0, Math.min(this.contents[i].length, newContents[i].length));
        }
        this.contents = newContents;
        this.inventoryData = this.menuType.createInventory(this.player, this.title);
    }

    public void setMenuProperty(@NotNull MenuProperty property, int value) {
        if (this.menuType.type() != property.getMenuType()) {
            throw new UnsupportedOperationException("Can't set property for a '" + String.valueOf((Object)property.getMenuType()) + "' inventory in a '" + String.valueOf((Object)this.menuType.type()) + "' inventory.");
        }
        if (!this.opened) {
            this.openActions.add(() -> OdalitaMenusNMS.getInstance().setInventoryProperty(this.getInventory(), property.getIndex(), value));
        } else {
            OdalitaMenusNMS.getInstance().setInventoryProperty(this.getInventory(), property.getIndex(), value);
        }
    }

    public synchronized void setGlobalCacheKey(@NotNull String globalCacheKey) {
        boolean putOld;
        boolean bl = putOld = !this.globalCacheKey.isEmpty() && !this.globalCacheKey.isBlank();
        if (this.globalCacheKey.equals(globalCacheKey) || globalCacheKey.isEmpty() || globalCacheKey.isBlank()) {
            return;
        }
        Map<String, Object> oldCache = putOld ? this.cache.getCache() : null;
        this.globalCacheKey = globalCacheKey;
        if (putOld) {
            this.cache.getCache().putAll(oldCache);
        }
    }

    @Nullable
    public MenuItem getContent(@NotNull SlotPos slotPos) {
        int row = slotPos.getRow();
        int column = slotPos.getColumn();
        if (row < 0 || row >= this.getRows() || column < 0 || column >= this.getColumns()) {
            return null;
        }
        return this.contents[row][column];
    }

    public boolean fits(int slot) {
        return this.menuType.fitsInMenu(slot);
    }

    @ApiStatus.Internal
    public void setClosed(boolean closed) {
        this.closed = closed;
        if (closed) {
            this.opened = false;
        }
    }

    @ApiStatus.Internal
    public void reopen() {
        this.builder.open();
    }

    public int getRows() {
        return Math.max(this.menuType.maxRows(), 1);
    }

    public int getColumns() {
        return this.menuType.maxColumns() + this.menuType.otherSlots().size();
    }

    public OdalitaMenus getInstance() {
        return this.instance;
    }

    public Player getPlayer() {
        return this.player;
    }

    public String getId() {
        return this.id;
    }

    public SupportedMenuType getMenuType() {
        return this.menuType;
    }

    public String getTitle() {
        return this.title;
    }

    public MenuContents getMenuContents() {
        return this.menuContents;
    }

    public boolean isHasUpdatableItems() {
        return this.hasUpdatableItems;
    }

    public String getGlobalCacheKey() {
        return this.globalCacheKey;
    }

    public MenuSessionCache getCache() {
        return this.cache;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Collection<Runnable> getOpenActions() {
        return this.openActions;
    }

    public void setContents(MenuItem[][] contents) {
        this.contents = contents;
    }

    public void setHasUpdatableItems(boolean hasUpdatableItems) {
        this.hasUpdatableItems = hasUpdatableItems;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public void setOpened(boolean opened) {
        this.opened = opened;
    }

    InventoryCreation getInventoryData() {
        return this.inventoryData;
    }
}

