/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.menu.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import nl.odalitadevelopments.menus.menu.MenuSession;
import nl.odalitadevelopments.menus.utils.collection.Table;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;

public final class GlobalSessionCache
implements Listener {
    private final Table<UUID, String, Map<String, Object>> playerMenuCache = new Table();

    public Map<String, Object> getOrCreateCache(@NotNull MenuSession menuSession) {
        String globalCacheKey;
        UUID uuid = menuSession.getPlayer().getUniqueId();
        Map<String, Object> cache = this.playerMenuCache.get(uuid, globalCacheKey = menuSession.getGlobalCacheKey());
        if (cache == null) {
            cache = new HashMap<String, Object>();
            this.playerMenuCache.put(uuid, globalCacheKey, cache);
        }
        return cache;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    private void onPlayerQuit(PlayerQuitEvent event) {
        this.cleanPlayerCache(event.getPlayer().getUniqueId());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    private void onPlayerKick(PlayerKickEvent event) {
        this.cleanPlayerCache(event.getPlayer().getUniqueId());
    }

    private void cleanPlayerCache(UUID playerUuid) {
        this.playerMenuCache.getRowMap().remove(playerUuid);
    }
}

