/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.menu.cache;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import nl.odalitadevelopments.menus.contents.MenuFrameData;
import nl.odalitadevelopments.menus.contents.MenuTask;
import nl.odalitadevelopments.menus.contents.action.MenuCloseResult;
import nl.odalitadevelopments.menus.contents.action.PlayerInventoryItemMetaChanger;
import nl.odalitadevelopments.menus.contents.placeableitem.PlaceableItemClickAction;
import nl.odalitadevelopments.menus.contents.placeableitem.PlaceableItemDragAction;
import nl.odalitadevelopments.menus.contents.placeableitem.PlaceableItemShiftClickAction;
import nl.odalitadevelopments.menus.contents.placeableitem.PlaceableItemsCloseAction;
import nl.odalitadevelopments.menus.items.MenuItem;
import nl.odalitadevelopments.menus.items.PageUpdatableItem;
import nl.odalitadevelopments.menus.iterators.MenuIterator;
import nl.odalitadevelopments.menus.listeners.OdalitaEventListener;
import nl.odalitadevelopments.menus.menu.MenuSession;
import nl.odalitadevelopments.menus.pagination.IPagination;
import nl.odalitadevelopments.menus.scrollable.Scrollable;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;

public final class MenuSessionCache {
    private final MenuSession menuSession;
    private final Map<String, IPagination<?, ?>> paginationMap = Maps.newConcurrentMap();
    private final Map<String, Scrollable> scrollableMap = Maps.newConcurrentMap();
    private final Map<Integer, Supplier<MenuItem>> refreshableItems = Maps.newConcurrentMap();
    private final Map<Integer, Supplier<PageUpdatableItem>> pageSwitchUpdateItems = Maps.newConcurrentMap();
    private final Map<String, MenuIterator> iterators = Maps.newConcurrentMap();
    private final List<Integer> placeableItems = Lists.newCopyOnWriteArrayList();
    private boolean allowPlaceableItemShiftClick = true;
    private boolean allowPlaceableItemDrag = true;
    private PlaceableItemsCloseAction placeableItemsCloseAction = null;
    private PlaceableItemClickAction placeableItemClickAction = null;
    private PlaceableItemShiftClickAction placeableItemShiftClickAction = null;
    private PlaceableItemDragAction placeableItemDragAction = null;
    private Consumer<InventoryClickEvent> playerInventoryClickAction = null;
    private Supplier<MenuCloseResult> closeActionBefore = null;
    private Supplier<MenuCloseResult> closeActionAfter = null;
    private Collection<OdalitaEventListener> eventListeners = new HashSet<OdalitaEventListener>();
    private PlayerInventoryItemMetaChanger itemMetaChanger = null;
    private final Map<String, MenuFrameData> frames = Maps.newConcurrentMap();
    private final Collection<Integer> frameOverlaySlots = Sets.newConcurrentHashSet();
    private String loadedFrameId = null;
    private final Map<String, MenuTask> tasks = Maps.newConcurrentMap();
    private final Map<String, Object> cache = Maps.newConcurrentMap();

    public MenuSessionCache(MenuSession menuSession) {
        this.menuSession = menuSession;
    }

    public synchronized <T> T cache(@NotNull String key, T def) {
        return (T)this.getCache().getOrDefault(key, def);
    }

    public synchronized <T> T cache(@NotNull String key) {
        return (T)this.getCache().get(key);
    }

    public synchronized void setCache(@NotNull String key, @NotNull Object value) {
        this.getCache().put(key, value);
    }

    public synchronized void pruneCache(@NotNull String key) {
        this.getCache().remove(key);
    }

    public Map<String, Object> getCache() {
        if (!this.menuSession.getGlobalCacheKey().isEmpty() && !this.menuSession.getGlobalCacheKey().isBlank()) {
            return this.menuSession.getInstance().getGlobalSessionCache().getOrCreateCache(this.menuSession);
        }
        return this.cache;
    }

    public MenuSession getMenuSession() {
        return this.menuSession;
    }

    public Map<String, IPagination<?, ?>> getPaginationMap() {
        return this.paginationMap;
    }

    public Map<String, Scrollable> getScrollableMap() {
        return this.scrollableMap;
    }

    public Map<Integer, Supplier<MenuItem>> getRefreshableItems() {
        return this.refreshableItems;
    }

    public Map<Integer, Supplier<PageUpdatableItem>> getPageSwitchUpdateItems() {
        return this.pageSwitchUpdateItems;
    }

    public Map<String, MenuIterator> getIterators() {
        return this.iterators;
    }

    public List<Integer> getPlaceableItems() {
        return this.placeableItems;
    }

    public boolean isAllowPlaceableItemShiftClick() {
        return this.allowPlaceableItemShiftClick;
    }

    public boolean isAllowPlaceableItemDrag() {
        return this.allowPlaceableItemDrag;
    }

    public PlaceableItemsCloseAction getPlaceableItemsCloseAction() {
        return this.placeableItemsCloseAction;
    }

    public PlaceableItemClickAction getPlaceableItemClickAction() {
        return this.placeableItemClickAction;
    }

    public PlaceableItemShiftClickAction getPlaceableItemShiftClickAction() {
        return this.placeableItemShiftClickAction;
    }

    public PlaceableItemDragAction getPlaceableItemDragAction() {
        return this.placeableItemDragAction;
    }

    public Consumer<InventoryClickEvent> getPlayerInventoryClickAction() {
        return this.playerInventoryClickAction;
    }

    public Supplier<MenuCloseResult> getCloseActionBefore() {
        return this.closeActionBefore;
    }

    public Supplier<MenuCloseResult> getCloseActionAfter() {
        return this.closeActionAfter;
    }

    public Collection<OdalitaEventListener> getEventListeners() {
        return this.eventListeners;
    }

    public PlayerInventoryItemMetaChanger getItemMetaChanger() {
        return this.itemMetaChanger;
    }

    public Map<String, MenuFrameData> getFrames() {
        return this.frames;
    }

    public Collection<Integer> getFrameOverlaySlots() {
        return this.frameOverlaySlots;
    }

    public String getLoadedFrameId() {
        return this.loadedFrameId;
    }

    public Map<String, MenuTask> getTasks() {
        return this.tasks;
    }

    public void setAllowPlaceableItemShiftClick(boolean allowPlaceableItemShiftClick) {
        this.allowPlaceableItemShiftClick = allowPlaceableItemShiftClick;
    }

    public void setAllowPlaceableItemDrag(boolean allowPlaceableItemDrag) {
        this.allowPlaceableItemDrag = allowPlaceableItemDrag;
    }

    public void setPlaceableItemsCloseAction(PlaceableItemsCloseAction placeableItemsCloseAction) {
        this.placeableItemsCloseAction = placeableItemsCloseAction;
    }

    public void setPlaceableItemClickAction(PlaceableItemClickAction placeableItemClickAction) {
        this.placeableItemClickAction = placeableItemClickAction;
    }

    public void setPlaceableItemShiftClickAction(PlaceableItemShiftClickAction placeableItemShiftClickAction) {
        this.placeableItemShiftClickAction = placeableItemShiftClickAction;
    }

    public void setPlaceableItemDragAction(PlaceableItemDragAction placeableItemDragAction) {
        this.placeableItemDragAction = placeableItemDragAction;
    }

    public void setPlayerInventoryClickAction(Consumer<InventoryClickEvent> playerInventoryClickAction) {
        this.playerInventoryClickAction = playerInventoryClickAction;
    }

    public void setCloseActionBefore(Supplier<MenuCloseResult> closeActionBefore) {
        this.closeActionBefore = closeActionBefore;
    }

    public void setCloseActionAfter(Supplier<MenuCloseResult> closeActionAfter) {
        this.closeActionAfter = closeActionAfter;
    }

    public void setEventListeners(Collection<OdalitaEventListener> eventListeners) {
        this.eventListeners = eventListeners;
    }

    public void setItemMetaChanger(PlayerInventoryItemMetaChanger itemMetaChanger) {
        this.itemMetaChanger = itemMetaChanger;
    }

    public void setLoadedFrameId(String loadedFrameId) {
        this.loadedFrameId = loadedFrameId;
    }
}

