/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.menu.type;

import java.util.function.Function;
import nl.odalitadevelopments.menus.menu.type.InventoryCreation;
import nl.odalitadevelopments.menus.nms.OdalitaMenusNMS;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;

public enum MenuType {
    ANVIL(InventoryType.ANVIL, player -> OdalitaMenusNMS.getInstance().createAnvilInventory((Player)player)),
    BEACON(InventoryType.BEACON),
    BLAST_FURNACE(InventoryType.BLAST_FURNACE),
    BREWING(InventoryType.BREWING),
    CARTOGRAPHY(InventoryType.CARTOGRAPHY, player -> OdalitaMenusNMS.getInstance().createCartographyInventory((Player)player)),
    CHEST_1_ROW(9),
    CHEST_2_ROW(18),
    CHEST_3_ROW(27),
    CHEST_4_ROW(36),
    CHEST_5_ROW(45),
    CHEST_6_ROW(54),
    CRAFTING(InventoryType.WORKBENCH, player -> OdalitaMenusNMS.getInstance().createCraftingInventory((Player)player)),
    ENCHANTING(InventoryType.ENCHANTING, player -> OdalitaMenusNMS.getInstance().createEnchantingInventory((Player)player)),
    FURNACE(InventoryType.FURNACE),
    GRINDSTONE(InventoryType.GRINDSTONE),
    HOPPER(InventoryType.HOPPER),
    LECTERN(InventoryType.LECTERN),
    LOOM(InventoryType.LOOM, player -> OdalitaMenusNMS.getInstance().createLoomInventory((Player)player)),
    SMITHING(InventoryType.SMITHING, player -> OdalitaMenusNMS.getInstance().createSmithingInventory((Player)player)),
    SMOKER(InventoryType.SMOKER),
    STONECUTTER(InventoryType.STONECUTTER, player -> OdalitaMenusNMS.getInstance().createStonecutterInventory((Player)player)),
    WINDOW_3X3(InventoryType.DROPPER);

    private final int size;
    private final InventoryType inventoryType;
    private final Function<Player, Object> nmsInventoryCreation;

    private MenuType(int size) {
        this.size = size;
        this.inventoryType = null;
        this.nmsInventoryCreation = null;
    }

    private MenuType(InventoryType inventoryType) {
        this.size = 0;
        this.inventoryType = inventoryType;
        this.nmsInventoryCreation = null;
    }

    private MenuType(InventoryType inventoryType, Function<Player, Object> nmsInventoryCreation) {
        this.size = 0;
        this.inventoryType = inventoryType;
        this.nmsInventoryCreation = nmsInventoryCreation;
    }

    @NotNull
    InventoryCreation createInventory(Player player, String title) {
        if (this.nmsInventoryCreation != null) {
            Object nmsInventory = this.nmsInventoryCreation.apply(player);
            Inventory bukkitInventory = OdalitaMenusNMS.getInstance().getInventoryFromNMS(nmsInventory);
            return new InventoryCreation(nmsInventory, bukkitInventory);
        }
        Inventory bukkitInventory = this.inventoryType == null ? Bukkit.getServer().createInventory(null, this.size, title) : Bukkit.getServer().createInventory(null, this.inventoryType, title);
        return new InventoryCreation(null, bukkitInventory);
    }
}

