/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.menu.type;

import java.util.Collection;
import java.util.Set;
import nl.odalitadevelopments.menus.contents.pos.SlotPos;
import nl.odalitadevelopments.menus.menu.type.InventoryCreation;
import nl.odalitadevelopments.menus.menu.type.MenuType;
import nl.odalitadevelopments.menus.menu.type.SupportedFeatures;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface SupportedMenuType {
    @NotNull
    public MenuType type();

    public int maxRows();

    public int maxColumns();

    @NotNull
    default public @NotNull Collection<@NotNull Integer> otherSlots() {
        return Set.of();
    }

    @NotNull
    default public @NotNull Collection<@NotNull SupportedFeatures> disallowedFeatures() {
        return Set.of();
    }

    default public boolean fitsInMenu(int slot) {
        boolean otherSlot = this.otherSlots().contains(slot);
        if (otherSlot) {
            return true;
        }
        if (this.maxColumns() == 0) {
            return false;
        }
        SlotPos slotPos = SlotPos.of(this.maxRows(), this.maxColumns(), slot);
        return slotPos.getRow() < this.maxRows() && slotPos.getColumn() < this.maxColumns();
    }

    default public boolean isFeatureAllowed(@NotNull SupportedFeatures feature) {
        return !this.disallowedFeatures().contains((Object)feature);
    }

    @ApiStatus.Internal
    @NotNull
    default public InventoryCreation createInventory(@NotNull Player player, @NotNull String title) {
        return this.type().createInventory(player, title);
    }
}

