/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.menu.type;

import java.util.HashMap;
import java.util.Map;
import nl.odalitadevelopments.menus.menu.type.MenuType;
import nl.odalitadevelopments.menus.menu.type.SupportedMenuType;
import nl.odalitadevelopments.menus.menu.type.types.AnvilMenuType;
import nl.odalitadevelopments.menus.menu.type.types.BeaconMenuType;
import nl.odalitadevelopments.menus.menu.type.types.BlastFurnaceMenuType;
import nl.odalitadevelopments.menus.menu.type.types.BrewingMenuType;
import nl.odalitadevelopments.menus.menu.type.types.CartographyMenuType;
import nl.odalitadevelopments.menus.menu.type.types.ChestFiveRowMenuType;
import nl.odalitadevelopments.menus.menu.type.types.ChestFourRowMenuType;
import nl.odalitadevelopments.menus.menu.type.types.ChestOneRowMenuType;
import nl.odalitadevelopments.menus.menu.type.types.ChestSixRowMenuType;
import nl.odalitadevelopments.menus.menu.type.types.ChestThreeRowMenuType;
import nl.odalitadevelopments.menus.menu.type.types.ChestTwoRowMenuType;
import nl.odalitadevelopments.menus.menu.type.types.CraftingMenuType;
import nl.odalitadevelopments.menus.menu.type.types.EnchantingMenuType;
import nl.odalitadevelopments.menus.menu.type.types.FurnaceMenuType;
import nl.odalitadevelopments.menus.menu.type.types.GrindstoneMenuType;
import nl.odalitadevelopments.menus.menu.type.types.HopperMenuType;
import nl.odalitadevelopments.menus.menu.type.types.LecternMenuType;
import nl.odalitadevelopments.menus.menu.type.types.LoomMenuType;
import nl.odalitadevelopments.menus.menu.type.types.SmithingMenuType;
import nl.odalitadevelopments.menus.menu.type.types.SmokerMenuType;
import nl.odalitadevelopments.menus.menu.type.types.StonecutterMenuType;
import nl.odalitadevelopments.menus.menu.type.types.WindowThreeThreeMenuType;
import org.jetbrains.annotations.NotNull;

public final class SupportedMenuTypes {
    private final Map<MenuType, SupportedMenuType> supportedMenuTypes = new HashMap<MenuType, SupportedMenuType>();

    public SupportedMenuTypes() {
        this.register(new AnvilMenuType());
        this.register(new BeaconMenuType());
        this.register(new BlastFurnaceMenuType());
        this.register(new BrewingMenuType());
        this.register(new CartographyMenuType());
        this.register(new ChestOneRowMenuType());
        this.register(new ChestTwoRowMenuType());
        this.register(new ChestThreeRowMenuType());
        this.register(new ChestFourRowMenuType());
        this.register(new ChestFiveRowMenuType());
        this.register(new ChestSixRowMenuType());
        this.register(new CraftingMenuType());
        this.register(new EnchantingMenuType());
        this.register(new FurnaceMenuType());
        this.register(new GrindstoneMenuType());
        this.register(new HopperMenuType());
        this.register(new LecternMenuType());
        this.register(new LoomMenuType());
        this.register(new SmithingMenuType());
        this.register(new SmokerMenuType());
        this.register(new StonecutterMenuType());
        this.register(new WindowThreeThreeMenuType());
    }

    @NotNull
    public SupportedMenuType getSupportedMenuType(@NotNull MenuType type) {
        SupportedMenuType menuType = this.supportedMenuTypes.get((Object)type);
        if (menuType == null) {
            throw new IllegalArgumentException("The menu type '" + String.valueOf((Object)type) + "' is not supported.");
        }
        return menuType;
    }

    private void register(@NotNull SupportedMenuType menuType) {
        this.supportedMenuTypes.put(menuType.type(), menuType);
    }
}

