/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.nms.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

public final class Reflections {
    public static <T> FieldAccessor<T> getField(Class<?> clazz, String name, Class<T> fieldType) {
        return Reflections.getField(clazz, name, fieldType, 0);
    }

    public static <T> FieldAccessor<T> getField(Class<?> clazz, Class<T> fieldType, int index) {
        return Reflections.getField(clazz, null, fieldType, index);
    }

    private static <T> FieldAccessor<T> getField(Class<?> clazz, String name, Class<T> fieldType, int index) {
        for (final Field field : clazz.getDeclaredFields()) {
            if (name != null && !field.getName().equals(name) || !fieldType.isAssignableFrom(field.getType()) || index-- > 0) continue;
            field.setAccessible(true);
            return new FieldAccessor<T>(){

                @Override
                public T get(Object target) {
                    try {
                        return field.get(target);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("Cannot access reflection.", e);
                    }
                }

                @Override
                public void set(Object target, Object value) {
                    try {
                        field.set(target, value);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("Cannot access reflection.", e);
                    }
                }

                @Override
                public boolean hasField(Object target) {
                    return field.getDeclaringClass().isAssignableFrom(target.getClass());
                }
            };
        }
        if (clazz.getSuperclass() != null) {
            return Reflections.getField(clazz.getSuperclass(), name, fieldType, index);
        }
        throw new IllegalArgumentException("Cannot find field with type " + String.valueOf(fieldType));
    }

    public static <T> FieldAccessor<T> getField(Class<?> clazz, Class<?> returnType, String ... fieldNames) {
        if (clazz != null) {
            try {
                for (String fieldName : fieldNames) {
                    Field field = clazz.getDeclaredField(fieldName);
                    if (returnType != null && !returnType.isAssignableFrom(field.getType())) continue;
                    field.setAccessible(true);
                    final Field finalField = field;
                    return new FieldAccessor<T>(){

                        @Override
                        public T get(Object target) {
                            try {
                                return finalField.get(target);
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException("Cannot access reflection.", e);
                            }
                        }

                        @Override
                        public void set(Object target, Object value) {
                            try {
                                finalField.set(target, value);
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException("Cannot access reflection.", e);
                            }
                        }

                        @Override
                        public boolean hasField(Object target) {
                            return finalField.getDeclaringClass().isAssignableFrom(target.getClass());
                        }
                    };
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Cannot find field with names " + Arrays.toString(fieldNames));
    }

    public static MethodInvoker getMethod(Class<?> clazz, String methodName, Class<?> ... params) {
        return Reflections.getTypedMethod(clazz, methodName, null, params);
    }

    public static Method getMethodSimply(Class<?> clazz, String method) {
        for (Method m : clazz.getMethods()) {
            if (!m.getName().equals(method)) continue;
            return m;
        }
        return null;
    }

    public static MethodInvoker getTypedMethod(Class<?> clazz, String methodName, Class<?> returnType, Class<?> ... params) {
        for (Method method : clazz.getDeclaredMethods()) {
            if ((methodName != null && !method.getName().equals(methodName) || returnType != null) && (!method.getReturnType().equals(returnType) || !Arrays.equals(method.getParameterTypes(), params))) continue;
            method.setAccessible(true);
            return (target, arguments) -> {
                try {
                    return method.invoke(target, arguments);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot invoke method " + String.valueOf(method), e);
                }
            };
        }
        if (clazz.getSuperclass() != null) {
            return Reflections.getMethod(clazz.getSuperclass(), methodName, params);
        }
        throw new IllegalStateException(String.format("Unable to find method %s (%s).", methodName, List.of(params)));
    }

    public static interface FieldAccessor<T> {
        public T get(Object var1);

        public void set(Object var1, Object var2);

        public boolean hasField(Object var1);
    }

    public static interface MethodInvoker {
        public Object invoke(Object var1, Object ... var2);
    }
}

