/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.nms.utils.version;

import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public enum ProtocolVersion {
    MINECRAFT_1_21_4(769),
    MINECRAFT_1_21_3(768),
    MINECRAFT_1_21_1(767),
    MINECRAFT_1_20_6(766),
    MINECRAFT_1_20_4(765),
    MINECRAFT_1_20_2(764),
    MINECRAFT_1_20_1(763),
    MINECRAFT_1_19_4(762),
    MINECRAFT_1_18_2(758),
    MINECRAFT_1_17_1(756),
    MINECRAFT_1_16_5(754),
    NOT_SUPPORTED(0);

    private final int number;
    private final String format;
    private static final ProtocolVersion SERVER_VERSION;

    private ProtocolVersion(int number) {
        this.number = number;
        this.format = number == 0 ? "Not supported" : this.name().substring(10).replaceAll("\\_", ".");
    }

    @NotNull
    public String format() {
        return this.format;
    }

    public int number() {
        return this.number;
    }

    public boolean isLowerOrEqual(@NotNull ProtocolVersion version) {
        return this.number <= version.number();
    }

    public boolean isLower(@NotNull ProtocolVersion version) {
        return this.number < version.number();
    }

    public boolean isHigherOrEqual(@NotNull ProtocolVersion version) {
        return this.number >= version.number();
    }

    public boolean isHigher(@NotNull ProtocolVersion version) {
        return this.number > version.number();
    }

    public boolean isEqual(@NotNull ProtocolVersion version) {
        return this.number == version.number();
    }

    @NotNull
    public static ProtocolVersion getServerVersion() {
        return SERVER_VERSION;
    }

    @NotNull
    public static ProtocolVersion getByVersionString(@NotNull String versionString) {
        for (ProtocolVersion protocolVersion : ProtocolVersion.values()) {
            String version;
            if (protocolVersion == NOT_SUPPORTED || !(version = protocolVersion.name().substring(10).replaceAll("_", ".")).equalsIgnoreCase(versionString)) continue;
            return protocolVersion;
        }
        return NOT_SUPPORTED;
    }

    @NotNull
    public static ProtocolVersion latest() {
        return ProtocolVersion.values()[0];
    }

    static {
        SERVER_VERSION = ProtocolVersion.getByVersionString(Bukkit.getServer().getVersion().split("\\(MC: ")[1].split("\\)")[0]);
    }
}

