/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.nms.v1_20_R2;

import io.netty.channel.Channel;
import io.papermc.paper.text.PaperComponents;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.ContainerCartography;
import net.minecraft.world.inventory.ContainerEnchantTable;
import net.minecraft.world.inventory.ContainerLoom;
import net.minecraft.world.inventory.ContainerPlayer;
import net.minecraft.world.inventory.ContainerSmithing;
import net.minecraft.world.inventory.ContainerStonecutter;
import net.minecraft.world.inventory.ContainerWorkbench;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.level.World;
import nl.odalitadevelopments.menus.nms.OdalitaMenusNMS;
import nl.odalitadevelopments.menus.nms.packet.ClientboundSetContentsPacket;
import nl.odalitadevelopments.menus.nms.packet.ClientboundSetSlotPacket;
import nl.odalitadevelopments.menus.nms.utils.OdalitaLogger;
import nl.odalitadevelopments.menus.nms.utils.PaperHelper;
import nl.odalitadevelopments.menus.nms.utils.ReflectionUtils;
import nl.odalitadevelopments.menus.nms.v1_20_R2.packet.ClientboundSetContentsPacket_v1_20_R2;
import nl.odalitadevelopments.menus.nms.v1_20_R2.packet.ClientboundSetSlotPacket_v1_20_R2;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftChatMessage;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public final class OdalitaMenusNMS_v1_20_R2
implements OdalitaMenusNMS {
    private static Class<?> MINECRAFT_INVENTORY;
    private static Field MINECRAFT_INVENTORY_TITLE_FIELD;
    private static Field PAPER_MINECRAFT_INVENTORY_TITLE_FIELD;
    private static Field TITLE_FIELD;
    private static Field WINDOW_ID_FIELD;
    private static Field NETWORK_MANAGER_FIELD;

    @Override
    public Inventory getTopInventory(InventoryEvent event) {
        return event.getView().getTopInventory();
    }

    @Override
    public Channel getPacketChannel(Player player) throws Exception {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        PlayerConnection serverGamePacketListener = serverPlayer.c;
        NETWORK_MANAGER_FIELD.setAccessible(true);
        NetworkManager connection = (NetworkManager)NETWORK_MANAGER_FIELD.get(serverGamePacketListener);
        NETWORK_MANAGER_FIELD.setAccessible(false);
        return connection.n;
    }

    @Override
    public void sendPacket(Player player, Object packetObject) {
        if (!(packetObject instanceof Packet)) {
            throw new IllegalArgumentException("Packet inside packet wrapper is not an instance of a minecraft packet!");
        }
        Packet packet = (Packet)packetObject;
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        serverPlayer.c.b(packet);
    }

    public IChatBaseComponent createChatBaseComponent(String string) {
        return CraftChatMessage.fromJSONOrNull((String)("{\"text\":\"" + string + "\"}"));
    }

    @Override
    public synchronized void setInventoryItem(Player player, int slot, ItemStack itemStack, Inventory inventory) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        Container activeContainer = serverPlayer.bS;
        int windowId = activeContainer.j;
        int stateId = activeContainer.k();
        if (activeContainer instanceof ContainerPlayer || windowId <= 0) {
            return;
        }
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        IInventory nmsInventory = ((CraftInventory)inventory).getInventory();
        List contents = nmsInventory.getContents();
        if (contents.size() <= slot) {
            return;
        }
        contents.set(slot, nmsItemStack);
        PacketPlayOutSetSlot packet = new PacketPlayOutSetSlot(windowId, stateId, slot, nmsItemStack);
        this.sendPacket(player, packet);
    }

    @Override
    public synchronized void changeInventoryTitle(Inventory inventory, String title) throws Exception {
        if (inventory.getViewers().isEmpty()) {
            IInventory nmsInventory = ((CraftInventory)inventory).getInventory();
            if (MINECRAFT_INVENTORY.isInstance(nmsInventory)) {
                Object minecraftInventory = MINECRAFT_INVENTORY.cast(nmsInventory);
                MINECRAFT_INVENTORY_TITLE_FIELD.setAccessible(true);
                MINECRAFT_INVENTORY_TITLE_FIELD.set(minecraftInventory, title);
                MINECRAFT_INVENTORY_TITLE_FIELD.setAccessible(false);
                if (PaperHelper.IS_PAPER) {
                    PAPER_MINECRAFT_INVENTORY_TITLE_FIELD.setAccessible(true);
                    PAPER_MINECRAFT_INVENTORY_TITLE_FIELD.set(minecraftInventory, PaperComponents.plainSerializer().deserialize(title));
                    PAPER_MINECRAFT_INVENTORY_TITLE_FIELD.setAccessible(false);
                }
            }
            return;
        }
        IChatBaseComponent titleComponent = this.createChatBaseComponent(title);
        for (HumanEntity viewer : inventory.getViewers()) {
            if (!(viewer instanceof Player)) continue;
            Player player = (Player)viewer;
            EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
            Container activeContainer = serverPlayer.bS;
            int windowId = activeContainer.j;
            if (windowId <= 0) continue;
            Containers type = activeContainer.a();
            PacketPlayOutOpenWindow packet = new PacketPlayOutOpenWindow(windowId, type, titleComponent);
            this.sendPacket(player, packet);
            TITLE_FIELD.setAccessible(true);
            TITLE_FIELD.set(activeContainer, titleComponent);
            TITLE_FIELD.setAccessible(false);
            activeContainer.b();
        }
    }

    @Override
    public synchronized void setInventoryProperty(Inventory inventory, int propertyIndex, int value) {
        for (HumanEntity viewer : inventory.getViewers()) {
            if (!(viewer instanceof Player)) continue;
            Player player = (Player)viewer;
            EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
            Container activeContainer = serverPlayer.bS;
            activeContainer.a(propertyIndex, value);
        }
    }

    @Override
    public void openInventory(Player player, Object inventory, String title) throws Exception {
        if (inventory instanceof Inventory) {
            Inventory bukkitInventory = (Inventory)inventory;
            player.openInventory(bukkitInventory);
            return;
        }
        Container nmsInventory = (Container)inventory;
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        int windowId = serverPlayer.nextContainerCounter();
        WINDOW_ID_FIELD.setAccessible(true);
        WINDOW_ID_FIELD.set(nmsInventory, windowId);
        WINDOW_ID_FIELD.setAccessible(false);
        IChatBaseComponent titleComponent = this.createChatBaseComponent(title);
        TITLE_FIELD.setAccessible(true);
        TITLE_FIELD.set(nmsInventory, titleComponent);
        TITLE_FIELD.setAccessible(false);
        serverPlayer.bS = nmsInventory;
        Containers type = nmsInventory.a();
        PacketPlayOutOpenWindow packet = new PacketPlayOutOpenWindow(windowId, type, titleComponent);
        this.sendPacket(player, packet);
        serverPlayer.a(nmsInventory);
    }

    @Override
    public Object createAnvilInventory(Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        PlayerInventory playerInventory = serverPlayer.fR();
        ContainerAnvil anvilMenu = new ContainerAnvil(-1, playerInventory);
        anvilMenu.checkReachable = false;
        return anvilMenu;
    }

    @Override
    public Object createCartographyInventory(Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        PlayerInventory playerInventory = serverPlayer.fR();
        ContainerCartography cartographyTableMenu = new ContainerCartography(-1, playerInventory, ContainerAccess.a((World)serverPlayer.dL(), (BlockPosition)serverPlayer.dl()));
        cartographyTableMenu.checkReachable = false;
        return cartographyTableMenu;
    }

    @Override
    public Object createCraftingInventory(Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        PlayerInventory playerInventory = serverPlayer.fR();
        ContainerWorkbench craftingMenu = new ContainerWorkbench(-1, playerInventory, ContainerAccess.a((World)serverPlayer.dL(), (BlockPosition)serverPlayer.dl()));
        craftingMenu.checkReachable = false;
        return craftingMenu;
    }

    @Override
    public Object createEnchantingInventory(Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        PlayerInventory playerInventory = serverPlayer.fR();
        ContainerEnchantTable enchantmentMenu = new ContainerEnchantTable(-1, playerInventory, ContainerAccess.a((World)serverPlayer.dL(), (BlockPosition)serverPlayer.dl()));
        enchantmentMenu.checkReachable = false;
        return enchantmentMenu;
    }

    @Override
    public Object createLoomInventory(Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        PlayerInventory playerInventory = serverPlayer.fR();
        ContainerLoom loomMenu = new ContainerLoom(-1, playerInventory);
        loomMenu.checkReachable = false;
        return loomMenu;
    }

    @Override
    public Object createSmithingInventory(Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        PlayerInventory playerInventory = serverPlayer.fR();
        ContainerSmithing smithingMenu = new ContainerSmithing(-1, playerInventory);
        smithingMenu.checkReachable = false;
        return smithingMenu;
    }

    @Override
    public Object createStonecutterInventory(Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        PlayerInventory playerInventory = serverPlayer.fR();
        ContainerStonecutter stonecutterMenu = new ContainerStonecutter(-1, playerInventory);
        stonecutterMenu.checkReachable = false;
        return stonecutterMenu;
    }

    @Override
    public Inventory getInventoryFromNMS(Object nmsInventory) {
        if (!(nmsInventory instanceof Container)) {
            return null;
        }
        Container menu = (Container)nmsInventory;
        return menu.getBukkitView().getTopInventory();
    }

    @Override
    public ClientboundSetSlotPacket readSetSlotPacket(Object packet) {
        if (!(packet instanceof PacketPlayOutSetSlot)) {
            return null;
        }
        PacketPlayOutSetSlot clientboundContainerSetSlotPacket = (PacketPlayOutSetSlot)packet;
        return new ClientboundSetSlotPacket_v1_20_R2(clientboundContainerSetSlotPacket);
    }

    @Override
    public ClientboundSetContentsPacket readSetContentsPacket(Object packet) {
        if (!(packet instanceof PacketPlayOutWindowItems)) {
            return null;
        }
        PacketPlayOutWindowItems clientboundContainerSetContentPacket = (PacketPlayOutWindowItems)packet;
        return new ClientboundSetContentsPacket_v1_20_R2(clientboundContainerSetContentPacket);
    }

    @Override
    public String setSlotPacketName() {
        return PacketPlayOutSetSlot.class.getSimpleName();
    }

    @Override
    public String windowItemsPacketName() {
        return PacketPlayOutWindowItems.class.getSimpleName();
    }

    static {
        try {
            MINECRAFT_INVENTORY = ReflectionUtils.obcClass("inventory.CraftInventoryCustom$MinecraftInventory");
            MINECRAFT_INVENTORY_TITLE_FIELD = MINECRAFT_INVENTORY.getDeclaredField("title");
            if (PaperHelper.IS_PAPER) {
                PAPER_MINECRAFT_INVENTORY_TITLE_FIELD = MINECRAFT_INVENTORY.getDeclaredField("adventure$title");
            }
            TITLE_FIELD = Container.class.getDeclaredField("title");
            WINDOW_ID_FIELD = Container.class.getDeclaredField("j");
            NETWORK_MANAGER_FIELD = ServerCommonPacketListenerImpl.class.getDeclaredField("c");
        }
        catch (Exception exception) {
            OdalitaLogger.error(exception);
        }
    }
}

