/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.pagination;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import nl.odalitadevelopments.menus.contents.MenuContents;
import nl.odalitadevelopments.menus.items.DisplayItem;
import nl.odalitadevelopments.menus.items.MenuItem;
import nl.odalitadevelopments.menus.iterators.AbstractMenuIterator;
import nl.odalitadevelopments.menus.pagination.IPagination;
import nl.odalitadevelopments.menus.pagination.PaginationBuilderImpl;
import nl.odalitadevelopments.menus.utils.BukkitThreadHelper;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

abstract class AbstractPagination<T extends IPagination<T, I>, I extends AbstractMenuIterator<I>>
implements IPagination<T, I> {
    protected final MenuContents contents;
    protected final I iterator;
    protected final String id;
    protected final int itemsPerPage;
    protected int currentPage = 0;
    protected boolean initialized = false;
    protected final boolean async;
    private volatile boolean switchingPage = false;
    private final T instance = this.self();

    AbstractPagination(PaginationBuilderImpl builder, I iterator) {
        this.contents = builder.contents;
        this.id = builder.id;
        this.itemsPerPage = builder.itemsPerPage;
        this.async = builder.async;
        this.iterator = iterator;
    }

    protected abstract T self();

    @Override
    @NotNull
    public final String id() {
        return this.id;
    }

    @Override
    public final int itemsPerPage() {
        return this.itemsPerPage;
    }

    @Override
    public final int currentPage() {
        return this.currentPage;
    }

    @Override
    public final int firstPage() {
        return 0;
    }

    @Override
    public final boolean isFirstPage() {
        return this.currentPage == this.firstPage();
    }

    @Override
    public final boolean isLastPage() {
        return this.currentPage == this.lastPage();
    }

    @Override
    @NotNull
    public final T nextPage() {
        return this.open(this.currentPage + 1);
    }

    @Override
    @NotNull
    public final T previousPage() {
        return this.open(this.currentPage - 1);
    }

    @Override
    @NotNull
    public final T open(int page) {
        if (this.switchingPage || page < 0 || page > this.lastPage()) {
            return this.instance;
        }
        this.switchingPage = true;
        BukkitThreadHelper.runCondition(this.async, this.contents.menuSession().getInstance().getJavaPlugin(), () -> {
            List<Supplier<MenuItem>> itemsOnPage = this.getItemsOnPage(page);
            if (itemsOnPage.isEmpty()) {
                this.switchingPage = false;
                return;
            }
            ((AbstractMenuIterator)this.iterator).reset();
            this.currentPage = page;
            this.contents.cache().getPageSwitchUpdateItems().forEach((slot, item) -> this.contents.set((int)slot, (MenuItem)item.get()));
            TreeMap<Integer, Supplier<MenuItem>> pageItems = new TreeMap<Integer, Supplier<MenuItem>>();
            for (Supplier<MenuItem> supplier : itemsOnPage) {
                int slot2 = ((AbstractMenuIterator)this.iterator).next();
                if (!this.contents.isEmpty(slot2)) {
                    this.contents.set(slot2, (MenuItem)DisplayItem.of(new ItemStack(Material.AIR)));
                }
                if (supplier == null) continue;
                pageItems.put(slot2, supplier);
            }
            for (Map.Entry entry : pageItems.entrySet()) {
                this.contents.set((Integer)entry.getKey(), (MenuItem)((Supplier)entry.getValue()).get());
            }
            this.switchingPage = false;
        });
        return this.instance;
    }

    @Override
    public boolean isAsync() {
        return this.async;
    }

    protected abstract List<Supplier<MenuItem>> getItemsOnPage(int var1);

    @Override
    @ApiStatus.Internal
    public final void setPage(int page) {
        if (this.initialized) {
            return;
        }
        this.currentPage = page;
    }

    @Override
    @ApiStatus.Internal
    public final void setInitialized() {
        this.initialized = true;
    }
}

