/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.pagination;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import nl.odalitadevelopments.menus.contents.MenuContents;
import nl.odalitadevelopments.menus.items.MenuItem;
import nl.odalitadevelopments.menus.iterators.MenuObjectIterator;
import nl.odalitadevelopments.menus.pagination.AbstractPagination;
import nl.odalitadevelopments.menus.pagination.ObjectPagination;
import nl.odalitadevelopments.menus.pagination.PaginationBuilderImpl;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

final class ObjectPaginationImpl<T>
extends AbstractPagination<ObjectPagination<T>, MenuObjectIterator<T>>
implements ObjectPagination<T> {
    ObjectPaginationImpl(PaginationBuilderImpl builder, MenuObjectIterator<T> iterator) {
        super(builder, iterator);
    }

    @Override
    protected ObjectPagination<T> self() {
        return this;
    }

    @Override
    @NotNull
    public MenuObjectIterator<T> iterator() {
        return (MenuObjectIterator)this.iterator;
    }

    @Override
    public int lastPage() {
        return Math.max(0, (int)(Math.ceil((double)((MenuObjectIterator)this.iterator).getObjects().size() / (double)this.itemsPerPage) - 1.0));
    }

    @Override
    @NotNull
    public ObjectPagination<T> addItem(@NotNull T value) {
        ((MenuObjectIterator)this.iterator).add(value);
        return this;
    }

    @Override
    @NotNull
    public ObjectPagination<T> emptyFilteredItemsAction(@NotNull Consumer<MenuContents> consumer) {
        ((MenuObjectIterator)this.iterator).emptyFilteredItemsAction(consumer);
        return this;
    }

    @Override
    @NotNull
    public ObjectPagination<T> emptyFilteredItemsAction(@NotNull Runnable runnable) {
        ((MenuObjectIterator)this.iterator).emptyFilteredItemsAction(runnable);
        return this;
    }

    @Override
    @NotNull
    public ObjectPagination<T> filter(@NotNull String id, @NotNull Predicate<T> predicate) {
        ((MenuObjectIterator)this.iterator).filter(id, predicate);
        return this;
    }

    @Override
    @NotNull
    public ObjectPagination<T> sorter(int priority, @NotNull @NotNull Comparator<@NotNull T> comparator) {
        ((MenuObjectIterator)this.iterator).sorter(priority, comparator);
        return this;
    }

    @Override
    @NotNull
    public ObjectPagination<T> removeFilter(@NotNull String id) {
        ((MenuObjectIterator)this.iterator).removeFilter(id);
        return this;
    }

    @Override
    @NotNull
    public ObjectPagination<T> removeSorter(int priority) {
        ((MenuObjectIterator)this.iterator).removeSorter(priority);
        return this;
    }

    @Override
    public boolean apply() {
        return ((MenuObjectIterator)this.iterator).apply();
    }

    @Override
    public void createBatch() {
        ((MenuObjectIterator)this.iterator).createBatch();
    }

    @Override
    public void endBatch() {
        ((MenuObjectIterator)this.iterator).endBatch();
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public List<Supplier<MenuItem>> getItemsOnPage() {
        if (this.initialized || this.contents.menuFrameData() != null) {
            return List.of();
        }
        return this.getItemsOnPage(this.currentPage);
    }

    @Override
    protected List<Supplier<MenuItem>> getItemsOnPage(int page) {
        ArrayList<Supplier<MenuItem>> items = new ArrayList<Supplier<MenuItem>>();
        List objects = ((MenuObjectIterator)this.iterator).getObjects();
        List pageList = objects.subList(page * this.itemsPerPage, Math.min(objects.size(), (page + 1) * this.itemsPerPage));
        for (Object value : pageList) {
            items.add(() -> ((MenuObjectIterator)this.iterator).createMenuItem(value));
        }
        for (int i = items.size(); i < this.itemsPerPage; ++i) {
            items.add(null);
        }
        return items;
    }
}

