/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.pagination;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import nl.odalitadevelopments.menus.contents.MenuContents;
import nl.odalitadevelopments.menus.items.MenuItem;
import nl.odalitadevelopments.menus.iterators.MenuIterator;
import nl.odalitadevelopments.menus.iterators.MenuObjectIterator;
import nl.odalitadevelopments.menus.pagination.ObjectPagination;
import nl.odalitadevelopments.menus.pagination.ObjectPaginationImpl;
import nl.odalitadevelopments.menus.pagination.Pagination;
import nl.odalitadevelopments.menus.pagination.PaginationBuilder;
import nl.odalitadevelopments.menus.pagination.PaginationImpl;
import org.jetbrains.annotations.NotNull;

final class PaginationBuilderImpl
implements PaginationBuilder {
    final MenuContents contents;
    final String id;
    final int itemsPerPage;
    boolean async = false;

    @Override
    @NotNull
    public PaginationBuilder asyncPageSwitching(boolean async) {
        this.async = async;
        return this;
    }

    @Override
    @NotNull
    public PaginationBuilder.ItemPaginationBuilder iterator(@NotNull MenuIterator iterator) {
        return new ItemPaginationBuilderImpl(this, iterator);
    }

    @Override
    @NotNull
    public PaginationBuilder.ItemPaginationBuilder iterator(@NotNull @NotNull Supplier<@NotNull MenuIterator> iteratorSupplier) {
        return this.iterator(iteratorSupplier.get());
    }

    @Override
    @NotNull
    public PaginationBuilder.ItemPaginationBuilder iterator(@NotNull @NotNull Function<@NotNull MenuContents, @NotNull MenuIterator> iteratorFunction) {
        return this.iterator(iteratorFunction.apply(this.contents));
    }

    @Override
    @NotNull
    public <T> PaginationBuilder.ObjectPaginationBuilder<T> objectIterator(@NotNull MenuObjectIterator<T> iterator) {
        return new ObjectPaginationBuilderImpl<T>(this, iterator);
    }

    @Override
    @NotNull
    public <T> PaginationBuilder.ObjectPaginationBuilder<T> objectIterator(@NotNull @NotNull Supplier<@NotNull MenuObjectIterator<T>> menuObjectIteratorSupplier) {
        return this.objectIterator(menuObjectIteratorSupplier.get());
    }

    @Override
    @NotNull
    public <T> PaginationBuilder.ObjectPaginationBuilder<T> objectIterator(@NotNull @NotNull Function<@NotNull MenuContents, @NotNull MenuObjectIterator<T>> menuContentsMenuObjectIteratorFunction) {
        return this.objectIterator(menuContentsMenuObjectIteratorFunction.apply(this.contents));
    }

    PaginationBuilderImpl(MenuContents contents, String id, int itemsPerPage) {
        this.contents = contents;
        this.id = id;
        this.itemsPerPage = itemsPerPage;
    }

    static final class ItemPaginationBuilderImpl
    implements PaginationBuilder.ItemPaginationBuilder {
        private final PaginationBuilderImpl builder;
        private final MenuIterator iterator;
        private List<Supplier<MenuItem>> items = new ArrayList<Supplier<MenuItem>>();

        @Override
        @NotNull
        public PaginationBuilder.ItemPaginationBuilder items(@NotNull @NotNull List<@NotNull Supplier<@NotNull MenuItem>> items) {
            this.items = items;
            return this;
        }

        @Override
        @NotNull
        public Pagination create() {
            if (this.iterator == null) {
                throw new IllegalStateException("You have to set an iterator before creating the pagination");
            }
            PaginationImpl pagination = new PaginationImpl(this.builder, this.iterator);
            this.items.forEach(pagination::addItem);
            this.builder.contents.menuSession().getCache().getPaginationMap().put(this.builder.id, pagination);
            return pagination;
        }

        private ItemPaginationBuilderImpl(PaginationBuilderImpl builder, MenuIterator iterator) {
            this.builder = builder;
            this.iterator = iterator;
        }
    }

    static final class ObjectPaginationBuilderImpl<T>
    implements PaginationBuilder.ObjectPaginationBuilder<T> {
        private final PaginationBuilderImpl builder;
        private final MenuObjectIterator<T> iterator;
        private Collection<T> objects = new ArrayList<T>();

        @Override
        @NotNull
        public PaginationBuilder.ObjectPaginationBuilder<T> objects(@NotNull @NotNull Collection<@NotNull T> objects) {
            this.objects = objects;
            return this;
        }

        @Override
        @NotNull
        public ObjectPagination<T> create() {
            if (this.iterator == null) {
                throw new IllegalStateException("You have to set an iterator before creating the pagination");
            }
            ObjectPaginationImpl<T> pagination = new ObjectPaginationImpl<T>(this.builder, this.iterator);
            this.iterator.pagination(pagination);
            this.objects.forEach(pagination::addItem);
            this.builder.contents.menuSession().getCache().getPaginationMap().put(this.builder.id, pagination);
            return pagination;
        }

        private ObjectPaginationBuilderImpl(PaginationBuilderImpl builder, MenuObjectIterator<T> iterator) {
            this.builder = builder;
            this.iterator = iterator;
        }
    }
}

