/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.pagination;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import nl.odalitadevelopments.menus.items.MenuItem;
import nl.odalitadevelopments.menus.iterators.MenuIterator;
import nl.odalitadevelopments.menus.pagination.AbstractPagination;
import nl.odalitadevelopments.menus.pagination.Pagination;
import nl.odalitadevelopments.menus.pagination.PaginationBuilderImpl;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

final class PaginationImpl
extends AbstractPagination<Pagination, MenuIterator>
implements Pagination {
    private final Map<Integer, List<Supplier<MenuItem>>> items = new HashMap<Integer, List<Supplier<MenuItem>>>();

    PaginationImpl(PaginationBuilderImpl builder, MenuIterator iterator) {
        super(builder, iterator);
    }

    @Override
    protected Pagination self() {
        return this;
    }

    @Override
    @NotNull
    public MenuIterator iterator() {
        return (MenuIterator)this.iterator;
    }

    @Override
    public int lastPage() {
        return Math.max(0, this.items.size() - 1);
    }

    @Override
    @NotNull
    public synchronized Pagination addItem(@NotNull @NotNull Supplier<@NotNull MenuItem> itemSupplier) {
        int pageIndex = Math.max(this.items.size() - 1, 0);
        int index = ((List)this.items.getOrDefault(pageIndex, new ArrayList())).size();
        if ((this.initialized || this.contents.menuFrameData() != null) && index < this.itemsPerPage && pageIndex == this.currentPage) {
            ((MenuIterator)this.iterator).setNext(itemSupplier.get());
        }
        if (index >= this.itemsPerPage) {
            ++pageIndex;
        }
        this.items.computeIfAbsent(pageIndex, integer -> new ArrayList()).add(itemSupplier);
        if (this.currentPage + 1 <= this.lastPage()) {
            this.contents.cache().getPageSwitchUpdateItems().forEach((slot, item) -> this.contents.set((int)slot, (MenuItem)item.get()));
        }
        return this;
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public List<Supplier<MenuItem>> getItemsOnPage() {
        if (this.initialized || this.contents.menuFrameData() != null) {
            return List.of();
        }
        return this.getItemsOnPage(this.currentPage);
    }

    @Override
    protected List<Supplier<MenuItem>> getItemsOnPage(int page) {
        List items = this.items.getOrDefault(page, new ArrayList());
        for (int i = items.size(); i < this.itemsPerPage; ++i) {
            items.add(null);
        }
        return items;
    }
}

