/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.patterns;

import nl.odalitadevelopments.menus.contents.pos.SlotPos;
import nl.odalitadevelopments.menus.iterators.MenuIterator;
import nl.odalitadevelopments.menus.patterns.MenuPattern;
import org.jetbrains.annotations.NotNull;

public interface IteratorPattern
extends MenuPattern<IteratorPattern> {
    @Override
    @NotNull
    default public IteratorPattern getCache() {
        return this;
    }

    default public int startingRow() {
        return 0;
    }

    default public int startingColumn() {
        return 0;
    }

    @Override
    default public void handle(@NotNull MenuIterator menuIterator) {
        for (int row = this.startingRow(); row < this.getPattern().size(); ++row) {
            String patternLine = this.getPattern().get(row);
            for (int column = this.startingColumn(); column < patternLine.length(); ++column) {
                if (patternLine.charAt(column) != '#') continue;
                menuIterator.blacklist(SlotPos.of(row + this.startingRow(), column + this.startingColumn()).getSlot());
            }
        }
    }
}

