/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.patterns;

import java.util.HashMap;
import java.util.Map;
import nl.odalitadevelopments.menus.patterns.MenuPattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PatternContainer {
    private final Map<Class<? extends MenuPattern>, Object> menuPatterns = new HashMap<Class<? extends MenuPattern>, Object>();

    public <CacheType, T extends MenuPattern<CacheType>> void registerPattern(@NotNull T pattern) {
        this.menuPatterns.putIfAbsent(pattern.getClass(), pattern.getCache());
    }

    @Nullable
    public <CacheType, T extends MenuPattern<CacheType>> CacheType getPattern(@NotNull Class<T> patternClass) {
        Object patternCache = this.menuPatterns.get(patternClass);
        if (patternCache == null) {
            return null;
        }
        try {
            return (CacheType)patternCache;
        }
        catch (ClassCastException e) {
            return null;
        }
    }
}

