/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.providers;

import nl.odalitadevelopments.menus.OdalitaMenus;
import nl.odalitadevelopments.menus.providers.processors.ColorProcessor;
import nl.odalitadevelopments.menus.providers.processors.CooldownProcessor;
import nl.odalitadevelopments.menus.providers.processors.DefaultItemProcessor;
import nl.odalitadevelopments.menus.providers.processors.packet.OdalitaPacketListenerProcessor;
import nl.odalitadevelopments.menus.providers.processors.packet.ProtocolLibPacketListenerProcessor;
import nl.odalitadevelopments.menus.providers.providers.ColorProvider;
import nl.odalitadevelopments.menus.providers.providers.CooldownProvider;
import nl.odalitadevelopments.menus.providers.providers.DefaultItemProvider;
import nl.odalitadevelopments.menus.providers.providers.MenuItemDataProvider;
import nl.odalitadevelopments.menus.providers.providers.PacketListenerProvider;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProvidersContainer {
    private final OdalitaMenus instance;
    private ColorProvider colorProvider;
    private CooldownProvider cooldownProvider;
    private DefaultItemProvider defaultItemProvider;
    private MenuItemDataProvider menuItemDataProvider;
    private PacketListenerProvider packetListenerProvider;

    public ProvidersContainer(@NotNull OdalitaMenus instance) {
        this.instance = instance;
        this.colorProvider = new ColorProcessor();
        this.cooldownProvider = new CooldownProcessor();
        this.defaultItemProvider = new DefaultItemProcessor();
        this.packetListenerProvider = Bukkit.getPluginManager().isPluginEnabled("ProtocolLib") ? new ProtocolLibPacketListenerProcessor(instance) : new OdalitaPacketListenerProcessor(instance);
    }

    public void close(@NotNull OdalitaMenus instance) {
        this.packetListenerProvider.close(instance);
    }

    public void setColorProvider(@NotNull ColorProvider colorProvider) {
        this.colorProvider = colorProvider;
    }

    public void setCooldownProvider(@NotNull CooldownProvider cooldownProvider) {
        this.cooldownProvider = cooldownProvider;
    }

    public void setDefaultItemProvider(@NotNull DefaultItemProvider defaultItemProvider) {
        this.defaultItemProvider = defaultItemProvider;
    }

    public void setMenuItemDataProvider(@NotNull MenuItemDataProvider menuItemDataProvider) {
        this.menuItemDataProvider = menuItemDataProvider;
    }

    public void setPacketListenerProvider(@NotNull PacketListenerProvider packetListenerProvider) {
        this.packetListenerProvider.close(this.instance);
        this.packetListenerProvider = packetListenerProvider;
    }

    @ApiStatus.Internal
    @NotNull
    public ColorProvider getColorProvider() {
        return this.colorProvider;
    }

    @ApiStatus.Internal
    @NotNull
    public CooldownProvider getCooldownProvider() {
        return this.cooldownProvider;
    }

    @ApiStatus.Internal
    @NotNull
    public DefaultItemProvider getDefaultItemProvider() {
        return this.defaultItemProvider;
    }

    @ApiStatus.Internal
    @Nullable
    public MenuItemDataProvider getMenuItemDataProvider() {
        return this.menuItemDataProvider;
    }

    @ApiStatus.Internal
    @NotNull
    public PacketListenerProvider getPacketListenerProvider() {
        return this.packetListenerProvider;
    }
}

