/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.providers.processors.packet;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import nl.odalitadevelopments.menus.OdalitaMenus;
import nl.odalitadevelopments.menus.nms.utils.version.ProtocolVersion;
import nl.odalitadevelopments.menus.providers.providers.PacketListenerProvider;
import nl.odalitadevelopments.menus.utils.packet.OdalitaMenuPacket;
import nl.odalitadevelopments.menus.utils.packet.OdalitaSetContentsPacket;
import nl.odalitadevelopments.menus.utils.packet.OdalitaSetSlotPacket;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class ProtocolLibPacketListenerProcessor
implements PacketListenerProvider {
    private static final Map<OdalitaMenus, Map<PacketListenerProvider.ClientboundPacketType, BiConsumer<Player, OdalitaMenuPacket>>> packetListenersClientbound = new HashMap<OdalitaMenus, Map<PacketListenerProvider.ClientboundPacketType, BiConsumer<Player, OdalitaMenuPacket>>>();
    private final OdalitaMenus instance;
    private final ProtocolManager protocolManager;
    private final PacketListener setSlotListener;
    private final PacketListener windowItemsListener;

    public ProtocolLibPacketListenerProcessor(OdalitaMenus instance) {
        this.instance = instance;
        packetListenersClientbound.put(instance, new HashMap());
        this.protocolManager = ProtocolLibrary.getProtocolManager();
        this.setSlotListener = this.listenSetSlot();
        this.protocolManager.addPacketListener(this.setSlotListener);
        this.windowItemsListener = this.listenWindowItems();
        this.protocolManager.addPacketListener(this.windowItemsListener);
    }

    @Override
    public void close(@NotNull OdalitaMenus instance) {
        packetListenersClientbound.remove(instance);
        this.protocolManager.removePacketListener(this.setSlotListener);
        this.protocolManager.removePacketListener(this.windowItemsListener);
    }

    @Override
    public void listenClientbound(@NotNull PacketListenerProvider.ClientboundPacketType clientboundPacketType, @NotNull @NotNull BiConsumer<@NotNull Player, @NotNull OdalitaMenuPacket> packetConsumer) {
        packetListenersClientbound.get(this.instance).put(clientboundPacketType, packetConsumer);
    }

    private PacketListener listenSetSlot() {
        return new PacketAdapter((Plugin)this.instance.getJavaPlugin(), ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Server.SET_SLOT}){

            public void onPacketSending(PacketEvent event) {
                boolean is1171 = ProtocolVersion.getServerVersion().isHigherOrEqual(ProtocolVersion.MINECRAFT_1_17_1);
                Player player = event.getPlayer();
                PacketContainer packet = event.getPacket();
                for (Map<PacketListenerProvider.ClientboundPacketType, BiConsumer<Player, OdalitaMenuPacket>> map : packetListenersClientbound.values()) {
                    for (Map.Entry<PacketListenerProvider.ClientboundPacketType, BiConsumer<Player, OdalitaMenuPacket>> entry : map.entrySet()) {
                        if (entry.getKey() != PacketListenerProvider.ClientboundPacketType.SET_SLOT) continue;
                        int windowId = (Integer)packet.getIntegers().read(0);
                        int stateId = is1171 ? (Integer)packet.getIntegers().read(1) : -1;
                        int slot = (Integer)packet.getIntegers().read(is1171 ? 2 : 1);
                        ItemStack item = (ItemStack)packet.getItemModifier().read(0);
                        OdalitaSetSlotPacket odalitaSetSlotPacket = new OdalitaSetSlotPacket(null, windowId, stateId, slot, item);
                        entry.getValue().accept(player, odalitaSetSlotPacket);
                        packet.getItemModifier().write(0, (Object)odalitaSetSlotPacket.item());
                    }
                }
            }
        };
    }

    private PacketListener listenWindowItems() {
        return new PacketAdapter((Plugin)this.instance.getJavaPlugin(), ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Server.WINDOW_ITEMS}){

            public void onPacketSending(PacketEvent event) {
                boolean is1171 = ProtocolVersion.getServerVersion().isHigherOrEqual(ProtocolVersion.MINECRAFT_1_17_1);
                Player player = event.getPlayer();
                PacketContainer packet = event.getPacket();
                for (Map<PacketListenerProvider.ClientboundPacketType, BiConsumer<Player, OdalitaMenuPacket>> map : packetListenersClientbound.values()) {
                    for (Map.Entry<PacketListenerProvider.ClientboundPacketType, BiConsumer<Player, OdalitaMenuPacket>> entry : map.entrySet()) {
                        if (entry.getKey() != PacketListenerProvider.ClientboundPacketType.SET_CONTENTS) continue;
                        int windowId = (Integer)packet.getIntegers().read(0);
                        int stateId = is1171 ? (Integer)packet.getIntegers().read(1) : -1;
                        List items = (List)packet.getItemListModifier().read(0);
                        ItemStack carriedItem = is1171 ? (ItemStack)packet.getItemModifier().read(0) : null;
                        OdalitaSetContentsPacket odalitaSetContentsPacket = new OdalitaSetContentsPacket(null, windowId, stateId, items, carriedItem);
                        entry.getValue().accept(player, odalitaSetContentsPacket);
                        packet.getItemListModifier().write(0, odalitaSetContentsPacket.items());
                    }
                }
            }
        };
    }
}

